/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.validator;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.Locale;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.el.VariableMapper;
import javax.faces.el.CompositeComponentExpressionHolder;
import org.nuxeo.ecm.platform.ui.web.model.ProtectedEditableModel;

public class ValueExpressionAnalyzer {
    private ValueExpression expression;

    public ValueExpressionAnalyzer(ValueExpression expression) {
        this.expression = expression;
    }

    public ValueReference getReference(ELContext elContext) {
        ValueExpression ve;
        Object prop;
        Object base;
        InterceptingResolver resolver = new InterceptingResolver(elContext.getELResolver());
        try {
            this.expression.setValue(this.decorateELContext(elContext, resolver), null);
        }
        catch (ELException ele) {
            return null;
        }
        ValueReference reference = resolver.getValueReference();
        if (reference != null && (base = reference.getBase()) instanceof CompositeComponentExpressionHolder && (prop = reference.getProperty()) instanceof String && (ve = ((CompositeComponentExpressionHolder)base).getExpression((String)prop)) != null) {
            this.expression = ve;
            reference = this.getReference(elContext);
        }
        return reference;
    }

    private ELContext decorateELContext(final ELContext context, final ELResolver resolver) {
        return new ELContext(){

            public ELResolver getELResolver() {
                return resolver;
            }

            public Object getContext(Class key) {
                return context.getContext(key);
            }

            public Locale getLocale() {
                return context.getLocale();
            }

            public boolean isPropertyResolved() {
                return context.isPropertyResolved();
            }

            public void putContext(Class key, Object contextObject) {
                context.putContext(key, contextObject);
            }

            public void setLocale(Locale locale) {
                context.setLocale(locale);
            }

            public void setPropertyResolved(boolean resolved) {
                context.setPropertyResolved(resolved);
            }

            public FunctionMapper getFunctionMapper() {
                return context.getFunctionMapper();
            }

            public VariableMapper getVariableMapper() {
                return context.getVariableMapper();
            }
        };
    }

    private static class InterceptingResolver
    extends ELResolver {
        private ELResolver delegate;
        private ValueReference valueReference;

        public InterceptingResolver(ELResolver delegate) {
            this.delegate = delegate;
        }

        public ValueReference getValueReference() {
            return this.valueReference;
        }

        public void setValue(ELContext context, Object base, Object property, Object value) {
            if (base != null && property != null) {
                context.setPropertyResolved(true);
                this.valueReference = new ValueReference(base, (Object)property.toString());
            }
        }

        public Object getValue(ELContext context, Object base, Object property) {
            Object value = this.delegate.getValue(context, base, property);
            if (base != null && ProtectedEditableModel.class.isAssignableFrom(base.getClass()) && "rowData".equals(property)) {
                return new ListItemMapper((ProtectedEditableModel)base, value);
            }
            return value;
        }

        public Class<?> getType(ELContext context, Object base, Object property) {
            return this.delegate.getType(context, base, property);
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) {
            return this.delegate.isReadOnly(context, base, property);
        }

        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            return this.delegate.getFeatureDescriptors(context, base);
        }

        public Class<?> getCommonPropertyType(ELContext context, Object base) {
            return this.delegate.getCommonPropertyType(context, base);
        }
    }

    static class ListItemMapper {
        protected ProtectedEditableModel model;
        protected Object value;

        public ListItemMapper(ProtectedEditableModel model, Object value) {
            this.model = model;
            this.value = value;
        }

        public ProtectedEditableModel getModel() {
            return this.model;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("ListItemMapper");
            buf.append(" {");
            buf.append(" model=");
            buf.append(this.model);
            buf.append(", value=");
            buf.append(this.value);
            buf.append('}');
            return buf.toString();
        }
    }
}

