/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.utils.reader;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import yarfraw.core.datamodel.ChannelFeed;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.YarfrawException;
import yarfraw.io.FeedReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedReaderUtils {
    private static final Log LOG = LogFactory.getLog(FeedReaderUtils.class);

    private FeedReaderUtils() {
    }

    public static List<ChannelFeed> readAll(ExecutorService executorService, HttpURL ... urls) throws YarfrawException {
        ArrayList<ChannelFeed> ret = new ArrayList<ChannelFeed>();
        ArrayList<Future<ChannelFeed>> futures = new ArrayList<Future<ChannelFeed>>();
        if (!ArrayUtils.isEmpty((Object[])urls)) {
            for (HttpURL url : urls) {
                futures.add(executorService.submit(new FeedReaderCaller(url)));
            }
        }
        for (Future future : futures) {
            try {
                ret.add((ChannelFeed)future.get());
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Interrupted exception received", (Throwable)e);
                ret.add(null);
            }
            catch (ExecutionException e) {
                LOG.error((Object)"Execution exception received", (Throwable)e);
                ret.add(null);
            }
        }
        return ret;
    }

    public static List<ChannelFeed> readAll(FeedFormat format, File ... files) throws YarfrawException {
        ArrayList<ChannelFeed> ret = new ArrayList<ChannelFeed>();
        if (!ArrayUtils.isEmpty((Object[])files)) {
            for (File f : files) {
                FeedReader reader = new FeedReader(f, format);
                ret.add(reader.readChannel());
            }
        }
        return ret;
    }

    public static ChannelFeed read(FeedFormat format, File file) throws YarfrawException {
        List<ChannelFeed> ret = FeedReaderUtils.readAll(format, file);
        return ret.size() == 0 ? null : ret.get(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FeedReaderCaller
    implements Callable<ChannelFeed> {
        private HttpURL _url;

        public FeedReaderCaller(HttpURL url) {
            this._url = url;
        }

        @Override
        public ChannelFeed call() throws YarfrawException, IOException {
            return new FeedReader(this._url).readChannel();
        }
    }
}

