/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.core.datamodel;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import yarfraw.core.datamodel.AbstractBaseObject;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.ValidationException;
import yarfraw.utils.ValidationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Id
extends AbstractBaseObject {
    private static final long serialVersionUID = 20070927L;
    private String _idValue;
    private Boolean _isPermaLink = true;

    public Id() {
    }

    public Id(String idValue) {
        this();
        this.setIdValue(idValue);
    }

    public String getIdValue() {
        return this._idValue;
    }

    public Id setIdValue(String idValue) {
        this._idValue = idValue;
        return this;
    }

    public Boolean isPermaLink() {
        return this._isPermaLink;
    }

    public Id setPermaLink(Boolean isPermaLink) {
        this._isPermaLink = isPermaLink == null || isPermaLink != false;
        return this;
    }

    public Id setOtherAttributes(Map<QName, String> otherAttributes) {
        this._otherAttributes = otherAttributes;
        return this;
    }

    public Id addOtherAttributes(QName namespace, String attribute) {
        if (this._otherAttributes == null) {
            this._otherAttributes = new HashMap();
        }
        this._otherAttributes.put(namespace, attribute);
        return this;
    }

    public Id setBase(String base) {
        this._base = base;
        return this;
    }

    public Id setLang(String lang) {
        this._lang = lang;
        return this;
    }

    public Id setLang(Locale lang) {
        this._lang = lang.getLanguage();
        return this;
    }

    @Override
    public void validate(FeedFormat format) throws ValidationException {
        if (format == FeedFormat.RSS10) {
            return;
        }
        ValidationUtils.validateNotNull("Id Value should not be null", this._idValue);
        if (format == FeedFormat.ATOM10) {
            ValidationUtils.validateUri("Id value should be an valid url", this._idValue);
        }
    }
}

