/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.holder;

import java.io.IOException;
import java.util.ArrayList;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasVariableMapper;
import org.nuxeo.ecm.platform.ui.web.component.holder.NuxeoValueHolderBean;
import org.nuxeo.ecm.platform.ui.web.component.holder.UIValueHolder;
import org.nuxeo.ecm.platform.ui.web.tag.handler.GenericHtmlComponentHandler;
import org.nuxeo.ecm.platform.ui.web.util.FaceletDebugTracer;

public class ValueHolderTagHandler
extends GenericHtmlComponentHandler {
    protected final Log log = LogFactory.getLog(ValueHolderTagHandler.class);
    protected final TagAttribute var = this.getAttribute("var");
    protected final TagAttribute skip = this.getAttribute("skip");

    public ValueHolderTagHandler(ComponentConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        boolean skipValue = false;
        if (this.skip != null) {
            skipValue = this.skip.getBoolean(ctx);
        }
        if (skipValue) {
            super.applyNextHandler(ctx, parent);
        } else {
            super.apply(ctx, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        long start = FaceletDebugTracer.start();
        String varName = null;
        try {
            boolean varSet = false;
            if (this.var != null) {
                varName = this.var.getValue(ctx);
            }
            VariableMapper orig = ctx.getVariableMapper();
            AliasVariableMapper alias = new AliasVariableMapper();
            String aliasId = (String)c.getAttributes().get("com.sun.faces.facelets.MARK_ID");
            alias.setId(aliasId);
            if (!StringUtils.isBlank((String)varName)) {
                varSet = true;
                ArrayList<String> blockedPatterns = new ArrayList<String>();
                blockedPatterns.add(varName);
                alias.setBlockedPatterns(blockedPatterns);
            }
            try {
                if (varSet) {
                    Object valueToExpose = this.retrieveValueToExpose(ctx, c);
                    ExpressionFactory eFactory = ctx.getExpressionFactory();
                    ValueExpression valueVe = eFactory.createValueExpression(valueToExpose, Object.class);
                    alias.setVariable(varName, valueVe);
                    VariableMapper vm = alias.getVariableMapperForBuild(orig);
                    ctx.setVariableMapper(vm);
                    AliasVariableMapper.exposeAliasesToRequest(ctx.getFacesContext(), alias);
                }
                super.applyNextHandler(ctx, c);
            }
            finally {
                if (varSet) {
                    AliasVariableMapper.removeAliasesExposedToRequest(ctx.getFacesContext(), aliasId);
                    ctx.setVariableMapper(orig);
                }
            }
        }
        catch (Throwable throwable) {
            FaceletDebugTracer.trace(start, this.getTag(), varName);
            throw throwable;
        }
        FaceletDebugTracer.trace(start, this.getTag(), varName);
    }

    protected Object retrieveValueToExpose(FaceletContext context, UIComponent comp) {
        if (comp instanceof UIValueHolder) {
            String fid;
            NuxeoValueHolderBean bean;
            UIValueHolder c = (UIValueHolder)comp;
            FacesContext faces = context.getFacesContext();
            if (PhaseId.RESTORE_VIEW.equals(faces.getCurrentPhaseId()) && (bean = c.lookupBean(faces)) != null && (fid = c.getFaceletId()) != null && bean.hasState(fid)) {
                return bean.getState(fid);
            }
            return c.getValueToExpose();
        }
        String className = null;
        if (comp != null) {
            className = comp.getClass().getName();
        }
        this.log.error((Object)("Associated component with class '" + className + "' is not a UIValueHolder instance => cannot retrieve value to expose."));
        return null;
    }
}

