/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import com.lowagie.text.ImgTemplate;
import com.lowagie.text.pdf.PdfTemplate;
import java.awt.Graphics2D;
import javax.faces.context.FacesContext;
import org.jboss.seam.pdf.ui.ITextComponent;
import org.jboss.seam.pdf.ui.UIDocument;

public abstract class UIGraphics2D
extends ITextComponent {
    private Image image = null;
    private int height = 300;
    private int width = 400;

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return (Integer)this.valueBinding("height", this.height);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return (Integer)this.valueBinding("width", this.width);
    }

    @Override
    public void createITextObject(FacesContext context) {
        UIDocument doc = (UIDocument)this.findITextParent(this.getParent(), UIDocument.class);
        if (doc != null) {
            PdfTemplate tp = doc.createPdfTemplate(this.getWidth(), this.getHeight());
            Graphics2D g2 = tp.createGraphics((float)this.getWidth(), (float)this.getHeight());
            this.render(g2);
            g2.dispose();
            try {
                this.image = new ImgTemplate(tp);
            }
            catch (BadElementException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public abstract void render(Graphics2D var1);

    @Override
    public void handleAdd(Object arg0) {
        throw new RuntimeException("No children allowed");
    }

    @Override
    public void removeITextObject() {
        this.image = null;
    }

    @Override
    public Object getITextObject() {
        return this.image;
    }
}

