/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.oauth2;

import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.admin.oauth.DirectoryBasedEditor;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.runtime.api.Framework;

@Name(value="oauth2ServiceProvidersActions")
@Scope(value=ScopeType.CONVERSATION)
public class OAuth2ServiceProvidersActionBean
extends DirectoryBasedEditor {
    private static final long serialVersionUID = 1L;
    protected static final String DIRECTORY = "oauth2ServiceProviders";
    protected static final String SCHEMA = "oauth2ServiceProvider";

    @Override
    protected String getDirectoryName() {
        return DIRECTORY;
    }

    @Override
    protected String getSchemaName() {
        return SCHEMA;
    }

    public String getAuthorizationURL(String provider) {
        OAuth2ServiceProviderRegistry oauth2ProviderRegistry = (OAuth2ServiceProviderRegistry)Framework.getService(OAuth2ServiceProviderRegistry.class);
        OAuth2ServiceProvider serviceProvider = oauth2ProviderRegistry.getProvider(provider);
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        return serviceProvider.getAuthorizationUrl(request);
    }

    public List<DocumentModel> getEnabledProviders() {
        ArrayList<DocumentModel> enabledProviders = new ArrayList<DocumentModel>();
        for (DocumentModel entry : this.getEntries()) {
            boolean isEnabled = (Boolean)entry.getProperty(SCHEMA, "enabled");
            String clientId = (String)entry.getProperty(SCHEMA, "clientId");
            String clientSecret = (String)entry.getProperty(SCHEMA, "clientSecret");
            if (!isEnabled || clientId == null || clientSecret == null) continue;
            enabledProviders.add(entry);
        }
        return enabledProviders;
    }
}

