/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.application;

import org.restlet.Application;
import org.restlet.Filter;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class TunnelFilter
extends Filter {
    private Application application;

    public TunnelFilter(Application application) {
        super(application.getContext());
        this.application = application;
    }

    public Application getApplication() {
        return this.application;
    }

    public void beforeHandle(Request request, Response response) {
        String methodName;
        super.beforeHandle(request, response);
        Form query = request.getResourceRef().getQueryAsForm(null);
        boolean queryModified = false;
        if (this.getApplication().getTunnelService().isMethodTunnel() && request.getMethod().equals((Object)Method.POST) && (methodName = query.getFirstValue(this.getApplication().getTunnelService().getMethodParameter())) != null) {
            request.setMethod(Method.valueOf((String)methodName));
            query.removeFirst(this.getApplication().getTunnelService().getMethodParameter());
            queryModified = true;
        }
        if (request.getMethod().equals((Object)Method.GET) && this.getApplication().getTunnelService().isPreferencesTunnel()) {
            String acceptCharset = query.getFirstValue(this.getApplication().getTunnelService().getCharacterSetAttribute());
            String acceptEncoding = query.getFirstValue(this.getApplication().getTunnelService().getEncodingAttribute());
            String acceptLanguage = query.getFirstValue(this.getApplication().getTunnelService().getLanguageAttribute());
            String acceptMediaType = query.getFirstValue(this.getApplication().getTunnelService().getMediaTypeAttribute());
            Metadata metadata = null;
            if (acceptCharset != null && (metadata = this.getApplication().getMetadataService().getMetadata(acceptCharset)) instanceof CharacterSet) {
                request.getClientInfo().getAcceptedCharacterSets().clear();
                request.getClientInfo().getAcceptedCharacterSets().add(new Preference((Metadata)((CharacterSet)metadata)));
                query.removeFirst(this.getApplication().getTunnelService().getCharacterSetAttribute());
                queryModified = true;
            }
            if (acceptEncoding != null && (metadata = this.getApplication().getMetadataService().getMetadata(acceptEncoding)) instanceof Encoding) {
                request.getClientInfo().getAcceptedEncodings().clear();
                request.getClientInfo().getAcceptedEncodings().add(new Preference((Metadata)((Encoding)metadata)));
                query.removeFirst(this.getApplication().getTunnelService().getEncodingAttribute());
                queryModified = true;
            }
            if (acceptLanguage != null && (metadata = this.getApplication().getMetadataService().getMetadata(acceptLanguage)) instanceof Language) {
                request.getClientInfo().getAcceptedLanguages().clear();
                request.getClientInfo().getAcceptedLanguages().add(new Preference((Metadata)((Language)metadata)));
                query.removeFirst(this.getApplication().getTunnelService().getLanguageAttribute());
                queryModified = true;
            }
            if (acceptMediaType != null && (metadata = this.getApplication().getMetadataService().getMetadata(acceptMediaType)) instanceof MediaType) {
                request.getClientInfo().getAcceptedMediaTypes().clear();
                request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)((MediaType)metadata)));
                query.removeFirst(this.getApplication().getTunnelService().getMediaTypeAttribute());
                queryModified = true;
            }
        }
        if (queryModified) {
            request.getResourceRef().setQuery(query.getQueryString(null));
        }
    }
}

