/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.file;

import com.sun.faces.util.MessageFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.platform.ui.web.application.NuxeoResponseStateManagerImpl;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileChoice;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;
import org.nuxeo.ecm.platform.ui.web.component.file.JSFBlobUploader;
import org.nuxeo.ecm.platform.ui.web.component.file.JSFBlobUploaderService;
import org.nuxeo.ecm.platform.ui.web.component.file.UIOutputFile;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.runtime.api.Framework;

public class UIInputFile
extends UIInput
implements NamingContainer {
    public static final String COMPONENT_TYPE = UIInputFile.class.getName();
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    protected static final String CHOICE_FACET_NAME = "choice";
    protected static final String UPLOAD_FACET_NAME = "upload";
    protected static final String DEFAULT_DOWNLOAD_FACET_NAME = "default_download";
    protected static final String DOWNLOAD_FACET_NAME = "download";
    protected static final String EDIT_FILENAME_FACET_NAME = "edit_filename";
    protected static final Log log = LogFactory.getLog(UIInputFile.class);
    protected final JSFBlobUploaderService uploaderService;
    protected String filename;
    protected Boolean editFilename;
    protected String onchange;
    protected String onclick;
    protected String onselect;

    public UIInputFile() {
        FacesContext faces = FacesContext.getCurrentInstance();
        Application app = faces.getApplication();
        ComponentUtils.initiateSubComponent((UIComponent)this, DEFAULT_DOWNLOAD_FACET_NAME, app.createComponent(UIOutputFile.COMPONENT_TYPE));
        ComponentUtils.initiateSubComponent((UIComponent)this, EDIT_FILENAME_FACET_NAME, app.createComponent("javax.faces.HtmlInputText"));
        this.uploaderService = (JSFBlobUploaderService)((Object)Framework.getService(JSFBlobUploaderService.class));
        for (JSFBlobUploader uploader : this.uploaderService.getJSFBlobUploaders()) {
            uploader.hookSubComponent(this);
        }
    }

    public String getRendererType() {
        return null;
    }

    public Object getValue() {
        Object localValue = this.getLocalValue();
        if (localValue != null) {
            return localValue;
        }
        Blob blob = null;
        Object originalValue = super.getValue();
        String mimeType = null;
        if (originalValue instanceof Blob) {
            blob = (Blob)originalValue;
            mimeType = blob.getMimeType();
        }
        List<String> choices = this.getAvailableChoices(blob, false);
        String choice = choices.get(0);
        return new InputFileInfo(choice, blob, this.getFilename(), mimeType);
    }

    public String getFilename() {
        if (this.filename != null) {
            return this.filename;
        }
        ValueExpression ve = this.getValueExpression("filename");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Boolean getEditFilename() {
        if (this.editFilename != null) {
            return this.editFilename;
        }
        ValueExpression ve = this.getValueExpression("editFilename");
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return false;
    }

    public void setEditFilename(Boolean editFilename) {
        this.editFilename = editFilename;
    }

    public InputFileInfo getFileInfoValue() {
        return (InputFileInfo)this.getValue();
    }

    public InputFileInfo getFileInfoLocalValue() {
        return (InputFileInfo)this.getLocalValue();
    }

    public InputFileInfo getFileInfoSubmittedValue() {
        return (InputFileInfo)this.getSubmittedValue();
    }

    protected String getStringValue(String name, String defaultValue) {
        ValueExpression ve = this.getValueExpression(name);
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return defaultValue;
    }

    public String getOnchange() {
        if (this.onchange != null) {
            return this.onchange;
        }
        return this.getStringValue("onchange", null);
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public String getOnclick() {
        if (this.onclick != null) {
            return this.onclick;
        }
        return this.getStringValue("onclick", null);
    }

    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    public String getOnselect() {
        if (this.onselect != null) {
            return this.onselect;
        }
        return this.getStringValue("onselect", null);
    }

    public void setOnselect(String onselect) {
        this.onselect = onselect;
    }

    public void decode(FacesContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.setValid(true);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String radioClientId = this.getClientId(context) + ':' + CHOICE_FACET_NAME;
        String choice = (String)requestMap.get(radioClientId);
        InputFileInfo submitted = new InputFileInfo(choice, null, null, null);
        this.setSubmittedValue(submitted);
    }

    public void validate(FacesContext context) {
        InputFileInfo previous;
        InputFileInfo submitted;
        block18: {
            String choice;
            if (context == null) {
                throw new IllegalArgumentException();
            }
            submitted = this.getFileInfoSubmittedValue();
            if (submitted == null) {
                return;
            }
            previous = this.getFileInfoValue();
            try {
                choice = submitted.getConvertedChoice();
            }
            catch (ConverterException ce) {
                ComponentUtils.addErrorMessage(context, (UIComponent)this, ce.getMessage());
                this.setValid(false);
                return;
            }
            if (choice == null) {
                ComponentUtils.addErrorMessage(context, (UIComponent)this, "error.inputFile.choiceRequired");
                this.setValid(false);
                return;
            }
            submitted.setChoice(choice);
            String previousChoice = previous.getConvertedChoice();
            boolean temp = InputFileChoice.isUploadOrKeepTemp(previousChoice);
            List<String> choices = this.getAvailableChoices(previous.getBlob(), temp);
            if (!choices.contains(choice)) {
                ComponentUtils.addErrorMessage(context, (UIComponent)this, "error.inputFile.invalidChoice");
                this.setValid(false);
                return;
            }
            if ("tempKeep".equals(choice) || "keep".equals(choice)) {
                if (this.isLocalValueSet() || "keep".equals(choice)) {
                    submitted.setInfo(previous);
                }
                if (this.getEditFilename().booleanValue()) {
                    this.validateFilename(context, submitted);
                }
            } else if (InputFileChoice.isUpload(choice)) {
                try {
                    this.uploaderService.getJSFBlobUploader(choice).validateUpload(this, context, submitted);
                    if (this.isValid()) {
                        submitted.setChoice("tempKeep");
                        break block18;
                    }
                    submitted.setInfo(previous);
                }
                catch (ValidatorException e) {
                    submitted.setInfo(previous);
                }
            } else if ("delete".equals(choice) || "none".equals(choice)) {
                submitted.setInfo(null);
            }
        }
        super.validateValue(context, (Object)submitted);
        if (this.isValid()) {
            this.setValue(submitted);
            this.setSubmittedValue(null);
            if (this.compareValues(previous, submitted)) {
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, (Object)previous, (Object)submitted));
            }
        }
    }

    public void validateFilename(FacesContext context, InputFileInfo submitted) {
        UIComponent filenameFacet = this.getFacet(EDIT_FILENAME_FACET_NAME);
        if (filenameFacet instanceof EditableValueHolder) {
            String filename;
            EditableValueHolder filenameComp = (EditableValueHolder)filenameFacet;
            submitted.setFilename(filenameComp.getLocalValue());
            try {
                filename = submitted.getConvertedFilename();
            }
            catch (ConverterException ce) {
                ComponentUtils.addErrorMessage(context, (UIComponent)this, ce.getMessage());
                this.setValid(false);
                return;
            }
            submitted.setFilename(filename);
        }
    }

    public void updateFilename(FacesContext context, String newFilename) {
        ValueExpression ve = this.getValueExpression("filename");
        if (ve != null) {
            ve.setValue(context.getELContext(), (Object)newFilename);
        }
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueExpression ve = this.getValueExpression("value");
        if (ve == null) {
            return;
        }
        try {
            InputFileInfo local = this.getFileInfoLocalValue();
            String choice = local.getConvertedChoice();
            if ("delete".equals(choice)) {
                ValueExpression vef = this.getValueExpression("filename");
                if (vef != null) {
                    vef.setValue(context.getELContext(), (Object)local.getConvertedFilename());
                }
                ve.setValue(context.getELContext(), (Object)local.getConvertedBlob());
                this.setValue(null);
                this.setLocalValueSet(false);
            } else if (InputFileChoice.isUploadOrKeepTemp(choice)) {
                ve.setValue(context.getELContext(), (Object)local.getConvertedBlob());
                this.setValue(null);
                this.setLocalValueSet(false);
                ValueExpression vef = this.getValueExpression("filename");
                if (vef != null) {
                    vef.setValue(context.getELContext(), (Object)local.getConvertedFilename());
                }
            } else if ("keep".equals(choice)) {
                ValueExpression vef;
                this.setValue(null);
                this.setLocalValueSet(false);
                if (this.getEditFilename().booleanValue() && (vef = this.getValueExpression("filename")) != null) {
                    vef.setValue(context.getELContext(), (Object)local.getConvertedFilename());
                }
            }
            return;
        }
        catch (ELException e) {
            String messageStr = e.getMessage();
            for (Throwable result = e.getCause(); result != null && result instanceof ELException; result = result.getCause()) {
                messageStr = result.getMessage();
            }
            FacesMessage message = messageStr == null ? MessageFactory.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageFactory.getLabel((FacesContext)context, (UIComponent)this)}) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
        catch (IllegalArgumentException | ConverterException e) {
            FacesMessage message = MessageFactory.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageFactory.getLabel((FacesContext)context, (UIComponent)this)});
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
    }

    protected List<String> getAvailableChoices(Blob blob, boolean temp) {
        BlobManager blobManager;
        BlobProvider blobProvider;
        ArrayList<String> choices = new ArrayList<String>(3);
        boolean isRequired = this.isRequired();
        if (blob != null) {
            choices.add(temp ? "tempKeep" : "keep");
        } else if (!isRequired) {
            choices.add("none");
        }
        boolean allowUpdate = true;
        if (blob != null && (blobProvider = (blobManager = (BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(blob)) != null && !blobProvider.supportsUserUpdate()) {
            allowUpdate = false;
        }
        if (allowUpdate) {
            for (JSFBlobUploader uploader : this.uploaderService.getJSFBlobUploaders()) {
                choices.add(uploader.getChoice());
            }
            if (blob != null && !isRequired) {
                choices.add("delete");
            }
        }
        return choices;
    }

    public Blob getCurrentBlob() {
        Blob blob = null;
        InputFileInfo submittedFileInfo = this.getFileInfoSubmittedValue();
        if (submittedFileInfo != null) {
            String choice = submittedFileInfo.getConvertedChoice();
            if (InputFileChoice.isKeepOrKeepTemp(choice)) {
                InputFileInfo fileInfo = this.getFileInfoValue();
                blob = fileInfo.getConvertedBlob();
            } else {
                blob = submittedFileInfo.getConvertedBlob();
            }
        } else {
            InputFileInfo fileInfo = this.getFileInfoValue();
            blob = fileInfo.getConvertedBlob();
        }
        return blob;
    }

    public String getCurrentFilename() {
        String filename = null;
        InputFileInfo submittedFileInfo = this.getFileInfoSubmittedValue();
        if (submittedFileInfo != null) {
            String choice = submittedFileInfo.getConvertedChoice();
            if (InputFileChoice.isKeepOrKeepTemp(choice)) {
                InputFileInfo fileInfo = this.getFileInfoValue();
                filename = fileInfo.getConvertedFilename();
            } else {
                filename = submittedFileInfo.getConvertedFilename();
            }
        } else {
            InputFileInfo fileInfo = this.getFileInfoValue();
            filename = fileInfo.getConvertedFilename();
        }
        return filename;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.notifyPreviousErrors(context);
        ResponseWriter writer = context.getResponseWriter();
        Blob blob = null;
        try {
            blob = this.getCurrentBlob();
        }
        catch (ConverterException converterException) {
            // empty catch block
        }
        String filename = null;
        try {
            filename = this.getCurrentFilename();
        }
        catch (ConverterException converterException) {
            // empty catch block
        }
        InputFileInfo fileInfo = this.getFileInfoSubmittedValue();
        if (fileInfo == null) {
            fileInfo = this.getFileInfoValue();
        }
        String currentChoice = fileInfo.getConvertedChoice();
        boolean temp = "tempKeep".equals(currentChoice);
        List<String> choices = this.getAvailableChoices(blob, temp);
        String radioClientId = this.getClientId(context) + ':' + CHOICE_FACET_NAME;
        writer.startElement("table", (UIComponent)this);
        writer.writeAttribute("class", (Object)"dataInput", null);
        writer.startElement("tbody", (UIComponent)this);
        writer.writeAttribute("class", this.getAttributes().get("styleClass"), null);
        for (String radioChoice : choices) {
            String onselect;
            String onclick;
            String onchange;
            String id = radioClientId + radioChoice;
            writer.startElement("tr", (UIComponent)this);
            writer.startElement("td", (UIComponent)this);
            writer.writeAttribute("class", (Object)"radioColumn", null);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("type", "radio");
            props.put("name", radioClientId);
            props.put("id", id);
            props.put("value", radioChoice);
            if (radioChoice.equals(currentChoice)) {
                props.put("checked", "checked");
            }
            if ((onchange = this.getOnchange()) != null) {
                props.put("onchange", onchange);
            }
            if ((onclick = this.getOnclick()) != null) {
                props.put("onclick", onclick);
            }
            if ((onselect = this.getOnselect()) != null) {
                props.put("onselect", onselect);
            }
            StringBuffer htmlBuffer = new StringBuffer();
            htmlBuffer.append("<input");
            for (Map.Entry prop : props.entrySet()) {
                htmlBuffer.append(" " + (String)prop.getKey() + "=\"" + (String)prop.getValue() + "\"");
            }
            htmlBuffer.append(" />");
            writer.write(htmlBuffer.toString());
            writer.endElement("td");
            writer.startElement("td", (UIComponent)this);
            writer.writeAttribute("class", (Object)"fieldColumn", null);
            String label = (String)ComponentUtils.getAttributeValue((UIComponent)this, radioChoice + "Label", null);
            if (label == null) {
                label = ComponentUtils.translate(context, "label.inputFile." + radioChoice + "Choice");
            }
            writer.write("<label for=\"" + id + "\" style=\"float:left\">" + label + "</label>");
            writer.write("&#x0020;");
            if (InputFileChoice.isKeepOrKeepTemp(radioChoice)) {
                UIComponent downloadFacet = this.getFacet(DOWNLOAD_FACET_NAME);
                if (downloadFacet != null) {
                    ComponentUtils.encodeComponent(context, downloadFacet);
                } else {
                    downloadFacet = this.getFacet(DEFAULT_DOWNLOAD_FACET_NAME);
                    if (downloadFacet != null) {
                        UIOutputFile downloadComp = (UIOutputFile)downloadFacet;
                        downloadComp.setQueryParent(true);
                        ComponentUtils.copyValues((UIComponent)this, (UIComponent)downloadComp, new String[]{"downloadLabel", "iconRendered"});
                        ComponentUtils.copyLinkValues((UIComponent)this, (UIComponent)downloadComp);
                        ComponentUtils.encodeComponent(context, (UIComponent)downloadComp);
                    }
                }
                if (this.getEditFilename().booleanValue()) {
                    writer.write("<br />");
                    UIComponent filenameFacet = this.getFacet(EDIT_FILENAME_FACET_NAME);
                    if (filenameFacet instanceof HtmlInputText) {
                        HtmlInputText filenameComp = (HtmlInputText)filenameFacet;
                        filenameComp.setValue((Object)filename);
                        filenameComp.setLocalValueSet(false);
                        String onClick = "document.getElementById('%s').checked='checked'";
                        filenameComp.setOnclick(String.format(onClick, id));
                        writer.write("&#x0020;");
                        label = (String)ComponentUtils.getAttributeValue((UIComponent)this, "editFilenameLabel", null);
                        if (label == null) {
                            label = ComponentUtils.translate(context, "label.inputFile.editFilename");
                        }
                        writer.write("<label for=\"" + filenameComp.getId() + "\">" + label + "</label>");
                        writer.write("&#x0020;");
                        ComponentUtils.encodeComponent(context, (UIComponent)filenameComp);
                    }
                }
            } else if (InputFileChoice.isUpload(radioChoice)) {
                String onChange = String.format("document.getElementById('%s').checked='checked'", id);
                this.uploaderService.getJSFBlobUploader(radioChoice).encodeBeginUpload(this, context, onChange);
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement("tbody");
        writer.endElement("table");
        writer.flush();
    }

    private void notifyPreviousErrors(FacesContext context) {
        Object hasError = context.getAttributes().get("NX_MULTIPART_SIZE_ERROR");
        String componentId = (String)context.getAttributes().get(NuxeoResponseStateManagerImpl.MULTIPART_SIZE_ERROR_COMPONENT_ID);
        if (Boolean.TRUE.equals(hasError)) {
            if (StringUtils.isBlank((String)componentId)) {
                ComponentUtils.addErrorMessage(context, (UIComponent)this, "error.inputFile.maxRequestSize", new Object[]{Framework.getProperty((String)"nuxeo.jsf.maxRequestSize")});
            } else if (componentId.equals(this.getFacet(UPLOAD_FACET_NAME).getClientId())) {
                ComponentUtils.addErrorMessage(context, (UIComponent)this, "error.inputFile.maxSize", new Object[]{Framework.getProperty((String)"nuxeo.jsf.maxFileSize")});
            }
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.filename, this.editFilename, this.onchange, this.onclick, this.onselect};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.filename = (String)values[1];
        this.editFilename = (Boolean)values[2];
        this.onchange = (String)values[3];
        this.onclick = (String)values[4];
        this.onselect = (String)values[5];
    }
}

