/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.seam;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.providers.ServiceProvider;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.STATELESS)
@Name(value="org.jboss.seam.extensions.provider")
@Install(precedence=10)
@BypassInterceptors
public class NuxeoRuntimeServiceProvider
implements ServiceProvider {
    private static final Log log = LogFactory.getLog(NuxeoRuntimeServiceProvider.class);
    protected static Map<String, Class> name2ServiceClassCache = new HashMap<String, Class>();
    protected static ReentrantLock name2ServiceClassLock = new ReentrantLock();

    public Object lookup(String name, Class type, boolean create) {
        if (Framework.getRuntime() == null) {
            return null;
        }
        if (type != null && type.isAssignableFrom(CoreSession.class)) {
            return null;
        }
        Object result = null;
        if (type != null) {
            result = Framework.getService((Class)type);
        }
        if (result == null && name != null && !name.startsWith("org.jboss") && result == null) {
            result = this.findServiceByShortCut(name);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Nuxeo Lookup => return " + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object findServiceByShortCut(String name) {
        if (!name2ServiceClassCache.containsKey(name)) {
            Class<?> klass = null;
            name2ServiceClassLock.lock();
            try {
                for (String serviceClassName : Framework.getRuntime().getComponentManager().getServices()) {
                    int p = serviceClassName.lastIndexOf(46);
                    String fullClassName = serviceClassName;
                    if (p > -1) {
                        serviceClassName = serviceClassName.substring(p + 1);
                    }
                    if (!name.equalsIgnoreCase(serviceClassName)) continue;
                    try {
                        klass = Thread.currentThread().getContextClassLoader().loadClass(fullClassName);
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)("Lookup for " + name + " resolved to service " + fullClassName));
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)("Unable to load class for service " + fullClassName), (Throwable)e);
                    }
                }
                name2ServiceClassCache.put(name, klass);
            }
            finally {
                name2ServiceClassLock.unlock();
            }
        }
        Class serviceClass = name2ServiceClassCache.get(name);
        Object result = null;
        if (serviceClass != null && (result = Framework.getService((Class)serviceClass)) != null && Contexts.isEventContextActive()) {
            Contexts.getEventContext().set(name, result);
        }
        return result;
    }
}

