/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.json;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Iterator;
import org.richfaces.json.JSONAccessor;
import org.richfaces.json.JSONArray;
import org.richfaces.json.JSONException;

public class JSONCollection
extends AbstractCollection
implements Serializable {
    private static final long serialVersionUID = 3192118108278773579L;
    private JSONArray array;

    public JSONCollection() throws JSONException {
        this.array = new JSONArray();
    }

    public JSONCollection(JSONArray array) throws JSONException {
        this.array = array;
    }

    public JSONCollection(String jsonString) throws JSONException {
        this.array = new JSONArray(jsonString);
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < JSONCollection.this.array.length();
            }

            public Object next() {
                try {
                    return JSONAccessor.unwrapValue(JSONCollection.this.array.get(this.index++));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    throw new RuntimeException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.array.length();
    }
}

