/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageSelection;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.cache.LRUCachingMap;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;

@Name(value="documentListingActions")
@Scope(value=ScopeType.CONVERSATION)
public class DocumentListingActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentListingActionsBean.class);
    public static String DEFAULT_LISTING_LAYOUT = "document_listing";
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient ContentViewActions contentViewActions;
    @In(required=false, create=true)
    protected transient DocumentsListsManager documentsListsManager;
    protected LRUCachingMap<String, String> docTolistings = new LRUCachingMap(20);
    protected String currentListingLayoutName = null;
    protected List<String> currentAvailableListingLayoutNames = null;

    @Deprecated
    public String getLayoutForDocument(DocumentModel doc) {
        if (doc != null) {
            String id = doc.getId();
            if (this.docTolistings.containsKey((Object)id)) {
                return (String)this.docTolistings.get((Object)id);
            }
            List<String> availableLayouts = this.getAvailableLayoutsForDocument(doc);
            if (availableLayouts != null && !availableLayouts.isEmpty()) {
                return availableLayouts.get(0);
            }
        }
        return DEFAULT_LISTING_LAYOUT;
    }

    @Deprecated
    public void setLayoutForDocument(DocumentModel doc, String layoutName) {
        if (doc == null) {
            log.error((Object)"Cannot set listing layout for null document");
            return;
        }
        String id = doc.getId();
        this.docTolistings.put((Object)id, (Object)layoutName);
    }

    @Deprecated
    @Factory(value="currentListingLayoutName", scope=ScopeType.EVENT)
    public String getLayoutForCurrentDocument() {
        if (this.currentListingLayoutName == null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            this.currentListingLayoutName = this.getLayoutForDocument(currentDocument);
        }
        return this.currentListingLayoutName;
    }

    @Deprecated
    public void setLayoutForCurrentDocument(String layoutName) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        this.setLayoutForDocument(currentDocument, layoutName);
        this.currentListingLayoutName = layoutName;
    }

    @Deprecated
    public List<String> getAvailableLayoutsForDocument(DocumentModel doc) {
        if (doc == null) {
            return Collections.emptyList();
        }
        TypeInfo typeInfo = (TypeInfo)doc.getAdapter(TypeInfo.class);
        String[] layoutNames = typeInfo.getLayouts("view", null);
        ArrayList<String> res = new ArrayList<String>();
        if (layoutNames != null && layoutNames.length > 0) {
            res.addAll(Arrays.asList(layoutNames));
        } else {
            res.add(DEFAULT_LISTING_LAYOUT);
        }
        return res;
    }

    @Deprecated
    @Factory(value="currentAvailableListingLayoutNames", scope=ScopeType.EVENT)
    public List<String> getAvailableLayoutsForCurrentDocument() {
        if (this.currentAvailableListingLayoutNames == null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            this.currentAvailableListingLayoutNames = this.getAvailableLayoutsForDocument(currentDocument);
        }
        return this.currentAvailableListingLayoutNames;
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged"}, create=false)
    @BypassInterceptors
    @Deprecated
    public void documentChanged() {
        this.currentListingLayoutName = null;
        this.currentAvailableListingLayoutNames = null;
    }

    protected List<DocumentModel> getCurrentPageDocuments(String contentViewName) {
        PageProvider cProvider;
        List documents = null;
        ContentView cView = this.contentViewActions.getContentView(contentViewName);
        if (cView != null && (cProvider = cView.getCurrentPageProvider()) != null) {
            List items = cProvider.getCurrentPage();
            try {
                documents = items;
            }
            catch (ClassCastException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        return documents;
    }

    public void processSelectPage(String contentViewName, String listName, Boolean selection) {
        List<DocumentModel> documents = this.getCurrentPageDocuments(contentViewName);
        if (documents != null) {
            String lName;
            String string = lName = listName == null ? "CURRENT_SELECTION" : listName;
            if (Boolean.TRUE.equals(selection)) {
                this.documentsListsManager.addToWorkingList(lName, documents);
            } else {
                this.documentsListsManager.removeFromWorkingList(lName, documents);
            }
        }
    }

    public void checkCurrentDocAndProcessSelectPage(String contentViewName, String listName, Boolean selection, String currentDocRef) {
        IdRef currentDocumentRef = new IdRef(currentDocRef);
        if (!currentDocumentRef.equals(this.navigationContext.getCurrentDocument().getRef())) {
            this.navigationContext.navigateToRef((DocumentRef)currentDocumentRef);
        }
        this.processSelectPage(contentViewName, listName, selection);
    }

    public void processSelectRow(String docRef, String contentViewName, String listName, Boolean selection) {
        String lName;
        List<DocumentModel> documents = this.getCurrentPageDocuments(contentViewName);
        DocumentModel doc = null;
        if (documents != null) {
            for (DocumentModel pagedDoc : documents) {
                if (!pagedDoc.getRef().toString().equals(docRef)) continue;
                doc = pagedDoc;
                break;
            }
        }
        if (doc == null) {
            log.error((Object)String.format("could not find doc '%s' in the current page of content view page provider '%s'", docRef, contentViewName));
            return;
        }
        String string = lName = listName == null ? "CURRENT_SELECTION" : listName;
        if (Boolean.TRUE.equals(selection)) {
            this.documentsListsManager.addToWorkingList(lName, doc);
        } else {
            this.documentsListsManager.removeFromWorkingList(lName, doc);
        }
    }

    public void checkCurrentDocAndProcessSelectRow(String docRef, String providerName, String listName, Boolean selection, String requestedCurrentDocRef) {
        IdRef requestedCurrentDocumentRef = new IdRef(requestedCurrentDocRef);
        DocumentRef currentDocumentRef = null;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument != null) {
            currentDocumentRef = currentDocument.getRef();
        }
        if (!requestedCurrentDocumentRef.equals(currentDocumentRef)) {
            this.navigationContext.navigateToRef((DocumentRef)requestedCurrentDocumentRef);
        }
        this.processSelectRow(docRef, providerName, listName, selection);
    }

    public void checkCurrentDocAndProcessVersionSelectRow(PageSelection<VersionModel> versionModelSelection, String requestedCurrentDocRef) {
        IdRef requestedCurrentDocumentRef = new IdRef(requestedCurrentDocRef);
        DocumentRef currentDocumentRef = null;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument != null) {
            currentDocumentRef = currentDocument.getRef();
        }
        if (!requestedCurrentDocumentRef.equals(currentDocumentRef)) {
            this.navigationContext.navigateToRef((DocumentRef)requestedCurrentDocumentRef);
        }
        this.processVersionSelectRow(versionModelSelection);
    }

    protected final void processVersionSelectRow(PageSelection<VersionModel> versionModelSelection) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            throw new NuxeoException("Cannot process version select row since current document is null.");
        }
        DocumentModel version = this.documentManager.getDocumentWithVersion(currentDocument.getRef(), (VersionModel)versionModelSelection.getData());
        if (version == null) {
            throw new NuxeoException("Cannot process version select row since selected version document is null.");
        }
        if (Boolean.TRUE.equals(versionModelSelection.isSelected())) {
            this.documentsListsManager.addToWorkingList("CURRENT_SELECTION_VERSIONS", version);
        } else {
            this.documentsListsManager.removeFromWorkingList("CURRENT_SELECTION_VERSIONS", version);
        }
    }
}

