/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.util;

import com.noelios.restlet.http.HttpUtils;
import com.noelios.restlet.util.HeaderReader;
import com.noelios.restlet.util.PreferenceUtils;
import java.io.IOException;
import java.util.Iterator;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Parameter;
import org.restlet.data.Preference;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceReader<T extends Metadata>
extends HeaderReader {
    public static final int TYPE_CHARACTER_SET = 1;
    public static final int TYPE_ENCODING = 2;
    public static final int TYPE_LANGUAGE = 3;
    public static final int TYPE_MEDIA_TYPE = 4;
    private int type;

    public PreferenceReader(int type, String header) {
        super(header);
        this.type = type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Preference<T> readPreference() throws IOException {
        Preference<T> result = null;
        boolean readingMetadata = true;
        boolean readingParamName = false;
        boolean readingParamValue = false;
        StringBuilder metadataBuffer = new StringBuilder();
        StringBuilder paramNameBuffer = null;
        StringBuilder paramValueBuffer = null;
        Form parameters = null;
        String nextValue = this.readValue();
        int nextIndex = 0;
        if (nextValue == null) return result;
        int nextChar = nextValue.charAt(nextIndex++);
        while (result == null) {
            if (readingMetadata) {
                if (nextChar == -1) {
                    if (metadataBuffer.length() > 0) {
                        result = this.createPreference(metadataBuffer, null);
                        paramNameBuffer = new StringBuilder();
                    }
                } else if (nextChar == 59) {
                    if (metadataBuffer.length() <= 0) throw new IOException("Empty metadata name detected.");
                    readingMetadata = false;
                    readingParamName = true;
                    paramNameBuffer = new StringBuilder();
                    parameters = new Form();
                } else if (!HttpUtils.isSpace(nextChar)) {
                    if (!HttpUtils.isText(nextChar)) throw new IOException("Control characters are not allowed within a metadata name.");
                    metadataBuffer.append((char)nextChar);
                }
            } else if (readingParamName) {
                if (nextChar == 61) {
                    if (paramNameBuffer.length() <= 0) throw new IOException("Empty parameter name detected.");
                    readingParamName = false;
                    readingParamValue = true;
                    paramValueBuffer = new StringBuilder();
                } else if (nextChar == -1) {
                    if (paramNameBuffer.length() <= 0) throw new IOException("Empty parameter name detected.");
                    parameters.add((Object)HttpUtils.createParameter(paramNameBuffer, null));
                    result = this.createPreference(metadataBuffer, (Series<Parameter>)parameters);
                } else if (nextChar == 59) {
                    parameters.add((Object)HttpUtils.createParameter(paramNameBuffer, null));
                    paramNameBuffer = new StringBuilder();
                    readingParamName = true;
                    readingParamValue = false;
                } else if (!HttpUtils.isSpace(nextChar) || paramNameBuffer.length() != 0) {
                    if (!HttpUtils.isTokenChar(nextChar)) throw new IOException("Separator and control characters are not allowed within a token.");
                    paramNameBuffer.append((char)nextChar);
                }
            } else if (readingParamValue) {
                if (nextChar == -1) {
                    if (paramValueBuffer.length() <= 0) throw new IOException("Empty parameter value detected");
                    parameters.add((Object)HttpUtils.createParameter(paramNameBuffer, paramValueBuffer));
                    result = this.createPreference(metadataBuffer, (Series<Parameter>)parameters);
                } else if (nextChar == 59) {
                    parameters.add((Object)HttpUtils.createParameter(paramNameBuffer, paramValueBuffer));
                    paramNameBuffer = new StringBuilder();
                    readingParamName = true;
                    readingParamValue = false;
                } else if (nextChar == 34 && paramValueBuffer.length() == 0) {
                    boolean done = false;
                    boolean quotedPair = false;
                    while (!done && nextChar != -1) {
                        int n = nextChar = nextIndex < nextValue.length() ? (int)nextValue.charAt(nextIndex++) : -1;
                        if (quotedPair) {
                            if (!HttpUtils.isText(nextChar)) throw new IOException("Invalid character detected in quoted string. Please check your value");
                            paramValueBuffer.append((char)nextChar);
                            quotedPair = false;
                            continue;
                        }
                        if (HttpUtils.isDoubleQuote(nextChar)) {
                            done = true;
                            continue;
                        }
                        if (nextChar == 92) {
                            quotedPair = true;
                            continue;
                        }
                        if (!HttpUtils.isText(nextChar)) throw new IOException("Invalid character detected in quoted string. Please check your value");
                        paramValueBuffer.append((char)nextChar);
                    }
                } else {
                    if (!HttpUtils.isTokenChar(nextChar)) throw new IOException("Separator and control characters are not allowed within a token");
                    paramValueBuffer.append((char)nextChar);
                }
            }
            nextChar = nextIndex < nextValue.length() ? (int)nextValue.charAt(nextIndex++) : -1;
        }
        return result;
    }

    protected Series<Parameter> extractMediaParams(Series<Parameter> parameters) {
        Form result = null;
        boolean qualityFound = false;
        Parameter param = null;
        if (parameters != null) {
            result = new Form();
            Iterator iter = parameters.iterator();
            while (!qualityFound && iter.hasNext()) {
                param = (Parameter)iter.next();
                if (param.getName().equals("q")) {
                    qualityFound = true;
                    continue;
                }
                iter.remove();
                result.add((Object)param);
            }
        }
        return result;
    }

    protected float extractQuality(Series<Parameter> parameters) {
        float result = 1.0f;
        boolean found = false;
        if (parameters != null) {
            Parameter param = null;
            Iterator iter = parameters.iterator();
            while (!found && iter.hasNext()) {
                param = (Parameter)iter.next();
                if (!param.getName().equals("q")) continue;
                result = PreferenceUtils.parseQuality(param.getValue());
                found = true;
                iter.remove();
            }
        }
        return result;
    }

    protected Preference<T> createPreference(CharSequence metadata, Series<Parameter> parameters) {
        Preference result;
        if (parameters == null) {
            result = new Preference();
            switch (this.type) {
                case 1: {
                    result.setMetadata((Metadata)CharacterSet.valueOf((String)((Object)metadata).toString()));
                    break;
                }
                case 2: {
                    result.setMetadata((Metadata)Encoding.valueOf((String)((Object)metadata).toString()));
                    break;
                }
                case 3: {
                    result.setMetadata((Metadata)Language.valueOf((String)((Object)metadata).toString()));
                    break;
                }
                case 4: {
                    result.setMetadata((Metadata)MediaType.valueOf((String)((Object)metadata).toString()));
                }
            }
        } else {
            Series<Parameter> mediaParams = this.extractMediaParams(parameters);
            float quality = this.extractQuality(parameters);
            result = new Preference(null, quality, parameters);
            switch (this.type) {
                case 1: {
                    result.setMetadata((Metadata)new CharacterSet(((Object)metadata).toString()));
                    break;
                }
                case 2: {
                    result.setMetadata((Metadata)new Encoding(((Object)metadata).toString()));
                    break;
                }
                case 3: {
                    result.setMetadata((Metadata)new Language(((Object)metadata).toString()));
                    break;
                }
                case 4: {
                    result.setMetadata((Metadata)new MediaType(((Object)metadata).toString(), mediaParams));
                }
            }
        }
        return result;
    }
}

