/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.admin.oauth.DirectoryBasedEditor;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.ecm.platform.oauth2.tokens.OAuth2TokenStore;
import org.nuxeo.runtime.api.Framework;

@Name(value="oauthUserTokens")
@Scope(value=ScopeType.CONVERSATION)
public class OAuth2UserTokensActions
extends DirectoryBasedEditor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Serializable> filter = new HashMap<String, Serializable>();
    @In(create=true)
    protected NuxeoPrincipal currentUser;

    protected String getDirectoryName() {
        return "oauth2Tokens";
    }

    protected String getSchemaName() {
        return "oauth2Token";
    }

    protected Map<String, Serializable> getQueryFilter() {
        return this.filter;
    }

    public DocumentModelList getProviderAccounts(String provider, boolean includeShared) {
        NuxeoOAuth2ServiceProvider serviceProvider = (NuxeoOAuth2ServiceProvider)((OAuth2ServiceProviderRegistry)Framework.getService(OAuth2ServiceProviderRegistry.class)).getProvider(provider);
        OAuth2TokenStore tokenStore = serviceProvider.getCredentialDataStore();
        DocumentModelListImpl filteredEntries = new DocumentModelListImpl();
        if (includeShared) {
            DocumentModelList tokens = tokenStore.query();
            List currentUserGroups = this.currentUser.getAllGroups();
            block0: for (DocumentModel entry : tokens) {
                String tokenOwner = (String)entry.getProperty(this.getSchemaName(), "nuxeoLogin");
                boolean isShared = (Boolean)entry.getProperty(this.getSchemaName(), "isShared");
                String sharedWith = (String)entry.getProperty(this.getSchemaName(), "sharedWith");
                if (tokenOwner.equals(this.currentUser.getName()) || isShared && sharedWith == null) {
                    filteredEntries.add((Object)entry);
                    continue;
                }
                if (!isShared || sharedWith == null) continue;
                List<String> sharedWithList = Arrays.asList(sharedWith.split(","));
                for (String item : sharedWithList) {
                    if (item.contains("group:") && currentUserGroups.contains(item = item.replace("group:", ""))) {
                        filteredEntries.add((Object)entry);
                        continue block0;
                    }
                    if (!item.contains("user:") || !(item = item.replace("user:", "")).equals(this.currentUser.getName())) continue;
                    filteredEntries.add((Object)entry);
                    continue block0;
                }
            }
        } else {
            this.filter.put("nuxeoLogin", (Serializable)((Object)this.currentUser.getName()));
            filteredEntries = tokenStore.query(this.filter);
        }
        return filteredEntries;
    }

    public DocumentModelList getCurrentUserTokens() {
        this.filter.clear();
        this.filter.put("nuxeoLogin", (Serializable)((Object)this.currentUser.getName()));
        this.refresh();
        return this.getEntries();
    }

    public List<String> getSharedWith() {
        List<String> sharedWith = new ArrayList<String>();
        String sharedWithProperty = (String)this.editableEntry.getProperty(this.getSchemaName(), "sharedWith");
        if (sharedWithProperty != null) {
            sharedWith = Arrays.asList(sharedWithProperty.split(","));
        }
        return sharedWith;
    }

    public void setSharedWith(List<String> sharedWith) {
        String list = StringUtils.join(sharedWith, (String)",");
        this.editableEntry.setProperty(this.getSchemaName(), "sharedWith", (Object)list);
    }
}

