/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.jsf.handler;

import com.sun.faces.facelets.tag.TagAttributeImpl;
import com.sun.faces.facelets.tag.TagAttributesImpl;
import com.sun.faces.facelets.tag.jsf.html.ScriptResourceHandler;
import com.sun.faces.facelets.tag.jsf.html.StylesheetResourceHandler;
import com.sun.faces.facelets.tag.ui.IncludeHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.MetaTagHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.tag.handler.LeafFaceletHandler;
import org.nuxeo.ecm.platform.ui.web.tag.handler.TagConfigFactory;
import org.nuxeo.ecm.web.resources.api.Resource;
import org.nuxeo.ecm.web.resources.api.ResourceContext;
import org.nuxeo.ecm.web.resources.api.ResourceContextImpl;
import org.nuxeo.ecm.web.resources.api.ResourceType;
import org.nuxeo.ecm.web.resources.api.service.WebResourceManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.styling.service.ThemeStylingService;
import org.nuxeo.theme.styling.service.descriptors.PageDescriptor;

public class PageResourceHandler
extends MetaTagHandler {
    private static final Log log = LogFactory.getLog(PageResourceHandler.class);
    protected final TagConfig config;
    protected final TagAttribute name;
    protected final TagAttribute type;
    protected final TagAttribute flavor;
    protected final TagAttribute target;
    protected final TagAttribute includeTimestamp;
    protected final TagAttribute[] vars;
    protected final ResourceType[] handledTypesArray = new ResourceType[]{ResourceType.css, ResourceType.js, ResourceType.jsfcss, ResourceType.jsfjs, ResourceType.html, ResourceType.xhtml, ResourceType.xhtmlfirst};

    public PageResourceHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.name = this.getAttribute("name");
        this.type = this.getAttribute("type");
        this.flavor = this.getAttribute("flavor");
        this.target = this.getAttribute("target");
        this.includeTimestamp = this.getAttribute("includeTimestamp");
        this.vars = this.tag.getAttributes().getAll();
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        return null;
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        ResourceType rtype;
        if (this.name == null) {
            return;
        }
        String pageName = this.name.getValue(ctx);
        ThemeStylingService tss = (ThemeStylingService)Framework.getService(ThemeStylingService.class);
        PageDescriptor page = tss.getPage(pageName);
        if (page == null) {
            return;
        }
        String typeValue = null;
        if (this.type != null) {
            typeValue = this.type.getValue(ctx);
        }
        if ((rtype = this.resolveType(typeValue)) == null) {
            log.error((Object)("Unsupported type '" + typeValue + "' on tag nxr:resourceBundle at " + this.tag.getLocation()));
            return;
        }
        String flavorValue = null;
        if (this.flavor != null) {
            flavorValue = this.flavor.getValue(ctx);
        }
        String targetValue = null;
        if (this.target != null) {
            targetValue = this.target.getValue(ctx);
        }
        String includeTimestampValue = null;
        if (this.includeTimestamp != null) {
            includeTimestampValue = this.includeTimestamp.getValue(ctx);
        }
        WebResourceManager wrm = (WebResourceManager)Framework.getService(WebResourceManager.class);
        LeafFaceletHandler leaf = new LeafFaceletHandler();
        if (rtype == ResourceType.any) {
            String cssTarget = targetValue;
            String jsTarget = targetValue;
            String htmlTarget = targetValue;
            if (this.vars != null) {
                for (TagAttribute var : this.vars) {
                    String val;
                    if ("target_css".equalsIgnoreCase(var.getLocalName())) {
                        val = this.resolveAttribute(ctx, var);
                        if (val == null) continue;
                        cssTarget = val;
                        continue;
                    }
                    if ("target_js".equalsIgnoreCase(var.getLocalName())) {
                        val = this.resolveAttribute(ctx, var);
                        if (val == null) continue;
                        jsTarget = val;
                        continue;
                    }
                    if (!"target_html".equalsIgnoreCase(var.getLocalName()) || (val = this.resolveAttribute(ctx, var)) == null) continue;
                    htmlTarget = val;
                }
            }
            this.applyPage(ctx, parent, wrm, page, ResourceType.jsfcss, flavorValue, cssTarget, includeTimestampValue, (FaceletHandler)leaf);
            this.applyPage(ctx, parent, wrm, page, ResourceType.jsfjs, flavorValue, jsTarget, includeTimestampValue, (FaceletHandler)leaf);
            this.applyPage(ctx, parent, wrm, page, ResourceType.xhtmlfirst, flavorValue, null, includeTimestampValue, (FaceletHandler)leaf);
            this.applyPage(ctx, parent, wrm, page, ResourceType.css, flavorValue, cssTarget, includeTimestampValue, this.nextHandler);
            this.applyPage(ctx, parent, wrm, page, ResourceType.js, flavorValue, jsTarget, includeTimestampValue, this.nextHandler);
            this.applyPage(ctx, parent, wrm, page, ResourceType.html, flavorValue, htmlTarget, includeTimestampValue, this.nextHandler);
            this.applyPage(ctx, parent, wrm, page, ResourceType.xhtml, flavorValue, null, includeTimestampValue, (FaceletHandler)leaf);
        } else {
            this.applyPage(ctx, parent, wrm, page, rtype, flavorValue, targetValue, includeTimestampValue, (FaceletHandler)leaf);
        }
    }

    protected void applyPage(FaceletContext ctx, UIComponent parent, WebResourceManager wrm, PageDescriptor page, ResourceType type, String flavor, String targetValue, String includeTimestamp, FaceletHandler nextHandler) throws IOException {
        switch (type) {
            case jsfjs: {
                Iterator<Resource> iterator = this.retrieveResources(wrm, page, type).iterator();
                while (iterator.hasNext()) {
                    Resource r;
                    String rtarget = (r = iterator.next()).getTarget();
                    ComponentConfig config = this.getJSFResourceComponentConfig(r, "javax.faces.resource.Script", rtarget == null ? targetValue : rtarget, includeTimestamp, nextHandler);
                    new ScriptResourceHandler(config).apply(ctx, parent);
                }
                break;
            }
            case jsfcss: {
                Iterator<Resource> iterator = this.retrieveResources(wrm, page, type).iterator();
                while (iterator.hasNext()) {
                    Resource r;
                    String rtarget = (r = iterator.next()).getTarget();
                    ComponentConfig config = this.getJSFResourceComponentConfig(r, "javax.faces.resource.Stylesheet", rtarget == null ? targetValue : rtarget, includeTimestamp, nextHandler);
                    new StylesheetResourceHandler(config).apply(ctx, parent);
                }
                break;
            }
            case xhtmlfirst: {
                this.includeXHTML(ctx, parent, this.retrieveResources(wrm, page, type), nextHandler);
                break;
            }
            case xhtml: {
                this.includeXHTML(ctx, parent, this.retrieveResources(wrm, page, type), nextHandler);
                break;
            }
            case js: {
                this.includePageResource(ctx, parent, page.getName(), type, flavor, targetValue, includeTimestamp, nextHandler);
                break;
            }
            case css: {
                this.includePageResource(ctx, parent, page.getName(), type, flavor, targetValue, includeTimestamp, nextHandler);
                break;
            }
            case html: {
                for (String bundle : page.getResourceBundles()) {
                    this.includeResourceBundle(ctx, parent, bundle, type, flavor, targetValue, includeTimestamp, nextHandler);
                }
                break;
            }
        }
    }

    protected List<Resource> retrieveResources(WebResourceManager wrm, String bundle, ResourceType type) {
        return wrm.getResources((ResourceContext)new ResourceContextImpl(), bundle, type.name());
    }

    protected List<Resource> retrieveResources(WebResourceManager wrm, PageDescriptor page, ResourceType type) {
        ArrayList<Resource> res = new ArrayList<Resource>();
        List bundles = page.getResourceBundles();
        for (String bundle : bundles) {
            res.addAll(this.retrieveResources(wrm, bundle, type));
        }
        return res;
    }

    protected String resolveAttribute(FaceletContext ctx, TagAttribute var) {
        String val = var.getValue(ctx);
        if (!StringUtils.isBlank((String)val)) {
            return val;
        }
        return null;
    }

    protected ResourceType resolveType(String type) {
        List<ResourceType> handled;
        if (StringUtils.isBlank((String)type)) {
            return ResourceType.any;
        }
        ResourceType parsed = ResourceType.parse((String)type);
        if (parsed != null && (handled = Arrays.asList(this.handledTypesArray)).contains(parsed)) {
            return parsed;
        }
        return null;
    }

    protected TagAttributeImpl getTagAttribute(String name, String value) {
        return new TagAttributeImpl(this.tag.getLocation(), "", name, name, value);
    }

    protected ComponentConfig getJSFResourceComponentConfig(Resource resource, String rendererType, String target, String includeTimestamp, FaceletHandler nextHandler) {
        String resourceName;
        String resourceLib;
        int i;
        String componentType = "javax.faces.Output";
        String uri = resource.getURI();
        int n = i = uri != null ? uri.indexOf(":") : -1;
        if (i > 0) {
            resourceLib = uri.substring(0, i);
            resourceName = uri.substring(i + 1);
        } else {
            resourceLib = null;
            resourceName = uri;
        }
        ArrayList<TagAttributeImpl> attrs = new ArrayList<TagAttributeImpl>();
        attrs.add(this.getTagAttribute("name", resourceName));
        if (!StringUtils.isBlank((String)resourceLib)) {
            attrs.add(this.getTagAttribute("library", resourceLib));
        }
        if (!StringUtils.isBlank((String)target)) {
            attrs.add(this.getTagAttribute("target", target));
        }
        if (!StringUtils.isBlank((String)includeTimestamp)) {
            attrs.add(this.getTagAttribute("includeTimestamp", includeTimestamp));
        }
        TagAttributesImpl attributes = new TagAttributesImpl(attrs.toArray(new TagAttribute[0]));
        ComponentConfig cconfig = TagConfigFactory.createComponentConfig((TagConfig)this.config, (String)this.tagId, (TagAttributes)attributes, (FaceletHandler)nextHandler, (String)componentType, (String)rendererType);
        return cconfig;
    }

    protected void includeXHTML(FaceletContext ctx, UIComponent parent, List<Resource> rs, FaceletHandler leaf) throws IOException {
        if (rs != null && !rs.isEmpty()) {
            for (Resource r : rs) {
                String uri = r.getURI();
                if (StringUtils.isBlank((String)uri)) {
                    log.error((Object)("Invalid resource '" + r.getName() + "': no uri defined at " + this.tag.getLocation()));
                    continue;
                }
                TagAttributeImpl srcAttr = this.getTagAttribute("src", uri);
                TagAttributesImpl attributes = new TagAttributesImpl(new TagAttribute[]{srcAttr});
                TagConfig xconfig = TagConfigFactory.createTagConfig((TagConfig)this.config, (String)this.tagId, (TagAttributes)attributes, (FaceletHandler)leaf);
                new IncludeHandler(xconfig).apply(ctx, parent);
            }
        }
    }

    protected void includeResourceBundle(FaceletContext ctx, UIComponent parent, String name, ResourceType type, String flavor, String target, String includeTimestamp, FaceletHandler nextHandler) throws IOException {
        String componentType = "javax.faces.Output";
        ArrayList<TagAttributeImpl> attrs = new ArrayList<TagAttributeImpl>();
        attrs.add(this.getTagAttribute("name", name));
        attrs.add(this.getTagAttribute("type", type.name()));
        if (!StringUtils.isBlank((String)target)) {
            attrs.add(this.getTagAttribute("target", target));
        }
        if (!StringUtils.isBlank((String)flavor)) {
            attrs.add(this.getTagAttribute("flavor", flavor));
        }
        if (!StringUtils.isBlank((String)includeTimestamp)) {
            attrs.add(this.getTagAttribute("includeTimestamp", includeTimestamp));
        }
        TagAttributesImpl attributes = new TagAttributesImpl(attrs.toArray(new TagAttribute[0]));
        ComponentConfig cconfig = TagConfigFactory.createComponentConfig((TagConfig)this.config, (String)this.tagId, (TagAttributes)attributes, (FaceletHandler)nextHandler, (String)componentType, (String)"org.nuxeo.ecm.web.resources.jsf.ResourceBundle");
        new ComponentHandler(cconfig).apply(ctx, parent);
    }

    protected void includePageResource(FaceletContext ctx, UIComponent parent, String name, ResourceType type, String flavor, String target, String includeTimestamp, FaceletHandler nextHandler) throws IOException {
        String componentType = "javax.faces.Output";
        ArrayList<TagAttributeImpl> attrs = new ArrayList<TagAttributeImpl>();
        attrs.add(this.getTagAttribute("name", name));
        attrs.add(this.getTagAttribute("type", type.name()));
        if (!StringUtils.isBlank((String)target)) {
            attrs.add(this.getTagAttribute("target", target));
        }
        if (!StringUtils.isBlank((String)flavor)) {
            attrs.add(this.getTagAttribute("flavor", flavor));
        }
        if (!StringUtils.isBlank((String)includeTimestamp)) {
            attrs.add(this.getTagAttribute("includeTimestamp", includeTimestamp));
        }
        TagAttributesImpl attributes = new TagAttributesImpl(attrs.toArray(new TagAttribute[0]));
        ComponentConfig cconfig = TagConfigFactory.createComponentConfig((TagConfig)this.config, (String)this.tagId, (TagAttributes)attributes, (FaceletHandler)nextHandler, (String)componentType, (String)"org.nuxeo.ecm.web.resources.jsf.PageResource");
        new ComponentHandler(cconfig).apply(ctx, parent);
    }
}

