/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.search.ui.seam;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewHeader;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.action.ActionContextProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.search.ui.SearchUIService;
import org.nuxeo.search.ui.localconfiguration.SearchConfiguration;

@Name(value="searchUIConfigurationActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class SearchUIConfigurationActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient ActionContextProvider actionContextProvider;
    @In(create=true)
    protected transient ContentViewService contentViewService;

    public List<ContentViewHeader> getSelectedContentViewHeaders() {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.getSelectedContentViewHeaders(currentDoc);
    }

    public List<ContentViewHeader> getSelectedContentViewHeaders(DocumentModel document) {
        if (!document.hasFacet("SearchConfiguration")) {
            return Collections.emptyList();
        }
        SearchUIService searchUIService = (SearchUIService)Framework.getService(SearchUIService.class);
        List<ContentViewHeader> contentViewHeaders = searchUIService.getContentViewHeaders(this.actionContextProvider.createActionContext());
        List<String> allowedContentViewNames = this.getAllowedContentViewNames(document);
        if (allowedContentViewNames.isEmpty()) {
            LocalConfigurationService localConfigurationService = (LocalConfigurationService)Framework.getService(LocalConfigurationService.class);
            SearchConfiguration configuration = (SearchConfiguration)localConfigurationService.getConfiguration(SearchConfiguration.class, "SearchConfiguration", document);
            if (configuration == null) {
                return contentViewHeaders;
            }
            allowedContentViewNames = configuration.getAllowedContentViewNames();
        }
        if (allowedContentViewNames.isEmpty()) {
            return contentViewHeaders;
        }
        ArrayList<ContentViewHeader> selectedContentViewHeaders = new ArrayList<ContentViewHeader>();
        for (ContentViewHeader contentViewHeader : contentViewHeaders) {
            if (!allowedContentViewNames.contains(contentViewHeader.getName())) continue;
            selectedContentViewHeaders.add(contentViewHeader);
        }
        return selectedContentViewHeaders;
    }

    public List<ContentViewHeader> getNotSelectedContentViewHeaders() {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.getNotSelectedContentViewHeaders(currentDoc);
    }

    public List<ContentViewHeader> getNotSelectedContentViewHeaders(DocumentModel document) {
        if (!document.hasFacet("SearchConfiguration")) {
            return Collections.emptyList();
        }
        ArrayList<ContentViewHeader> notSelectedContentViewHeaders = new ArrayList<ContentViewHeader>();
        List<ContentViewHeader> selectedContentViewHeaders = this.getSelectedContentViewHeaders(document);
        SearchUIService searchUIService = (SearchUIService)Framework.getService(SearchUIService.class);
        List<ContentViewHeader> contentViewHeaders = searchUIService.getContentViewHeaders(this.actionContextProvider.createActionContext());
        for (ContentViewHeader contentViewHeader : contentViewHeaders) {
            if (selectedContentViewHeaders.contains(contentViewHeader)) continue;
            notSelectedContentViewHeaders.add(contentViewHeader);
        }
        return notSelectedContentViewHeaders;
    }

    protected List<String> getAllowedContentViewNames(DocumentModel doc) {
        SearchConfiguration adapter = (SearchConfiguration)doc.getAdapter(SearchConfiguration.class);
        if (adapter == null) {
            return Collections.emptyList();
        }
        return adapter.getAllowedContentViewNames();
    }
}

