/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.ui;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import org.jboss.seam.excel.ExcelWorkbook;
import org.jboss.seam.excel.WorksheetItem;
import org.jboss.seam.excel.ui.UIWorkbook;
import org.jboss.seam.excel.ui.command.Command;
import org.jboss.seam.ui.util.JSF;

public abstract class ExcelComponent
extends UIComponentBase {
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String DEFAULT_CHARACTER_ENCODING = "utf-8";
    private String styleClass;
    private String style;

    public static String cmp2String(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter oldResponseWriter = facesContext.getResponseWriter();
        String contentType = oldResponseWriter != null ? oldResponseWriter.getContentType() : DEFAULT_CONTENT_TYPE;
        String characterEncoding = oldResponseWriter != null ? oldResponseWriter.getCharacterEncoding() : DEFAULT_CHARACTER_ENCODING;
        RenderKit renderKit = facesContext.getRenderKit();
        StringWriter cacheingWriter = new StringWriter();
        ResponseWriter newResponseWriter = renderKit.createResponseWriter((Writer)cacheingWriter, contentType, characterEncoding);
        facesContext.setResponseWriter(newResponseWriter);
        JSF.renderChild((FacesContext)facesContext, (UIComponent)component);
        if (oldResponseWriter != null) {
            facesContext.setResponseWriter(oldResponseWriter);
        }
        cacheingWriter.flush();
        cacheingWriter.close();
        return cacheingWriter.toString();
    }

    public static <T> List<T> getChildrenOfType(List<UIComponent> children, Class<T> childType) {
        ArrayList<UIComponent> matches = new ArrayList<UIComponent>();
        for (UIComponent child : children) {
            if (!childType.isAssignableFrom(child.getClass())) continue;
            matches.add(child);
        }
        return matches;
    }

    protected static List<Command> getCommands(List<UIComponent> children) {
        return ExcelComponent.getChildrenOfType(children, Command.class);
    }

    protected static List<WorksheetItem> getItems(List<UIComponent> children) {
        return ExcelComponent.getChildrenOfType(children, WorksheetItem.class);
    }

    protected Object valueOf(String name, Object defaultValue) {
        Object value = defaultValue;
        if (this.getValueExpression(name) != null) {
            value = this.getValueExpression(name).getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return value;
    }

    protected ExcelWorkbook getWorkbook(UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof UIWorkbook) {
            UIWorkbook uiWorkBook = (UIWorkbook)component;
            return uiWorkBook.getExcelWorkbook();
        }
        return this.getWorkbook(component.getParent());
    }

    protected UIComponent getParentByClass(UIComponent root, Class searchClass) {
        if (root == null) {
            return null;
        }
        if (root.getClass() == searchClass) {
            return root;
        }
        return this.getParentByClass(root.getParent(), searchClass);
    }

    public String getStyleClass() {
        return (String)this.valueOf("styleClass", this.styleClass);
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyle() {
        return (String)this.valueOf("style", this.style);
    }

    public void setStyle(String style) {
        this.style = style;
    }
}

