/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.web.common.session.NuxeoHttpSessionMonitor;
import org.nuxeo.ecm.platform.web.common.session.SessionInfo;
import org.nuxeo.runtime.api.Framework;

@Name(value="usersActivityInfo")
@Scope(value=ScopeType.CONVERSATION)
public class UsersActivityManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(UsersActivityManager.class);
    protected String selectedAuditTimeRange;
    protected String selectedAuditCategory;
    protected String selectedHttpSessionsTimeRange;
    protected int currentAuditPage = 1;
    protected static int pageSize = 25;

    public List<SelectItem> getAuditTimeRanges() {
        int i;
        ArrayList<SelectItem> ranges = new ArrayList<SelectItem>();
        for (i = 1; i < 13; ++i) {
            ranges.add(new SelectItem((Object)(i + "h"), "label.timerange." + i + "h"));
        }
        for (i = 1; i < 8; ++i) {
            ranges.add(new SelectItem((Object)(i * 24 + "h"), "label.timerange." + i + "d"));
        }
        for (i = 2; i < 6; ++i) {
            ranges.add(new SelectItem((Object)(168 * i + "h"), "label.timerange." + i + "w"));
        }
        return ranges;
    }

    public List<SelectItem> getAuditCategories() {
        ArrayList<SelectItem> ranges = new ArrayList<SelectItem>();
        ranges.add(new SelectItem((Object)"NuxeoAuthentication", "label.audit.auth"));
        ranges.add(new SelectItem((Object)"eventDocumentCategory", "label.audit.doc"));
        ranges.add(new SelectItem((Object)"eventLifeCycleCategory", "label.audit.lifecycle"));
        ranges.add(new SelectItem((Object)"all", "label.audit.all"));
        return ranges;
    }

    public String getSelectedAuditTimeRange() {
        if (this.selectedAuditTimeRange == null) {
            this.selectedAuditTimeRange = "1h";
        }
        return this.selectedAuditTimeRange;
    }

    public void setSelectedAuditTimeRange(String dateRange) {
        this.selectedAuditTimeRange = dateRange;
        this.currentAuditPage = 1;
        Contexts.getEventContext().remove("userLoginEvents");
    }

    public String getSelectedAuditCategory() {
        if (this.selectedAuditCategory == null) {
            this.selectedAuditCategory = "all";
        }
        return this.selectedAuditCategory;
    }

    public void setSelectedAuditCategory(String category) {
        this.selectedAuditCategory = category;
        this.currentAuditPage = 1;
        Contexts.getEventContext().remove("userLoginEvents");
    }

    public int getCurrentAuditPage() {
        return this.currentAuditPage;
    }

    public void nextAuditPage() {
        ++this.currentAuditPage;
        Contexts.getEventContext().remove("userLoginEvents");
    }

    public void prevAuditPage() {
        --this.currentAuditPage;
        if (this.currentAuditPage <= 0) {
            this.currentAuditPage = 1;
        }
        Contexts.getEventContext().remove("userLoginEvents");
    }

    @Factory(value="userLoginEvents", scope=ScopeType.EVENT)
    public List<LogEntry> getLoginInfo() {
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        String[] cat = new String[]{this.getSelectedAuditCategory()};
        if (this.getSelectedAuditCategory().equals("all")) {
            cat = new String[]{};
        }
        return reader.queryLogsByPage(new String[0], this.selectedAuditTimeRange, cat, null, this.currentAuditPage, pageSize);
    }

    public List<SelectItem> getHttpSessionsTimeRanges() {
        ArrayList<SelectItem> ranges = new ArrayList<SelectItem>();
        ranges.add(new SelectItem((Object)"300s", "label.timerange.5m"));
        ranges.add(new SelectItem((Object)"600s", "label.timerange.10m"));
        ranges.add(new SelectItem((Object)"1200s", "label.timerange.20m"));
        ranges.add(new SelectItem((Object)"1800s", "label.timerange.30m"));
        ranges.add(new SelectItem((Object)"3600s", "label.timerange.1h"));
        ranges.add(new SelectItem((Object)"7200s", "label.timerange.2h"));
        ranges.add(new SelectItem((Object)"14400s", "label.timerange.4h"));
        ranges.add(new SelectItem((Object)"all", "label.timerange.all"));
        return ranges;
    }

    public String getSelectedHttpSessionsTimeRange() {
        if (this.selectedHttpSessionsTimeRange == null) {
            this.selectedHttpSessionsTimeRange = "1800s";
        }
        return this.selectedHttpSessionsTimeRange;
    }

    public void setSelectedHttpSessionsTimeRange(String dateRange) {
        this.selectedHttpSessionsTimeRange = dateRange;
        Contexts.getEventContext().remove("userHttpSessions");
    }

    @Factory(value="nbActiveUserHttpSessions", scope=ScopeType.EVENT)
    public int getUserSessionsCount() {
        return NuxeoHttpSessionMonitor.instance().getSortedSessions().size();
    }

    @Factory(value="nbUserRequests", scope=ScopeType.EVENT)
    public long getUserRequestCount() {
        return NuxeoHttpSessionMonitor.instance().getGlobalRequestCounter();
    }

    @Factory(value="userHttpSessions", scope=ScopeType.EVENT)
    public List<SessionInfo> getUserSessions() {
        if (this.getSelectedHttpSessionsTimeRange().equals("all")) {
            return NuxeoHttpSessionMonitor.instance().getSortedSessions();
        }
        long maxInactivity = Long.parseLong(this.selectedHttpSessionsTimeRange.replace("s", ""));
        return NuxeoHttpSessionMonitor.instance().getSortedSessions(maxInactivity);
    }
}

