/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.writer.impl;

import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.richfaces.resource.optimizer.resource.writer.ResourceProcessor;

public class CSSCompressingProcessor
implements ResourceProcessor {
    private Charset charset;

    public CSSCompressingProcessor(Charset charset) {
        this.charset = charset;
    }

    @Override
    public boolean isSupportedFile(String name) {
        return name.endsWith(".css");
    }

    @Override
    public void process(String outputName, ByteSource byteSource, ByteSink byteSink, boolean closeAtFinish) throws IOException {
        this.process(outputName, byteSource.openStream(), byteSink.openStream(), closeAtFinish);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String outputName, InputStream in, OutputStream out, boolean closeAtFinish) throws IOException {
        Reader reader = null;
        Writer writer = null;
        try {
            reader = new InputStreamReader(in, this.charset);
            writer = new OutputStreamWriter(out, this.charset);
            new CssCompressor(reader).compress(writer, 0);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            if (closeAtFinish) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            } else {
                writer.flush();
            }
        }
    }
}

