/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.table;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.table.RtfBorderGroup;
import com.lowagie.text.rtf.table.RtfRow;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfCell
extends Cell
implements RtfExtendedElement {
    private static final int MERGE_NONE = 0;
    private static final int MERGE_VERT_PARENT = 1;
    private static final int MERGE_VERT_CHILD = 2;
    private RtfRow parentRow = null;
    private ArrayList content = null;
    private int cellRight = 0;
    private int cellWidth = 0;
    private RtfBorderGroup borders = null;
    private RtfColor backgroundColor = null;
    private int cellPadding = 0;
    private int mergeType = 0;
    private RtfDocument document = null;
    private boolean inHeader = false;
    private boolean deleted = false;
    private boolean usePadding = false;
    private float cellPaddingLeft = 0.0f;
    private float cellPaddingTop = 0.0f;
    private float cellPaddingBottom = 0.0f;
    private float cellPaddingRight = 0.0f;

    public RtfCell() {
        this.borders = new RtfBorderGroup();
        this.verticalAlignment = 5;
    }

    public RtfCell(String content) {
        super(content);
        this.borders = new RtfBorderGroup();
        this.verticalAlignment = 5;
    }

    public RtfCell(Element element) throws BadElementException {
        super(element);
        this.borders = new RtfBorderGroup();
        this.verticalAlignment = 5;
    }

    protected RtfCell(boolean deleted) {
        this.deleted = deleted;
        this.verticalAlignment = 5;
    }

    protected RtfCell(RtfDocument doc, RtfRow row, Cell cell) {
        this.document = doc;
        this.parentRow = row;
        this.importCell(cell);
    }

    protected RtfCell(RtfDocument doc, RtfRow row, PdfPCell cell) {
        this.document = doc;
        this.parentRow = row;
        this.importCell(cell);
    }

    private void importCell(Cell cell) {
        this.content = new ArrayList();
        if (cell == null) {
            this.borders = new RtfBorderGroup(this.document, 2, this.parentRow.getParentTable().getBorders());
            return;
        }
        this.colspan = cell.getColspan();
        this.rowspan = cell.getRowspan();
        if (cell.getRowspan() > 1) {
            this.mergeType = 1;
        }
        this.borders = cell instanceof RtfCell ? new RtfBorderGroup(this.document, 2, ((RtfCell)cell).getBorders()) : new RtfBorderGroup(this.document, 2, cell.getBorder(), cell.getBorderWidth(), cell.getBorderColor());
        this.verticalAlignment = cell.getVerticalAlignment();
        this.backgroundColor = cell.getBackgroundColor() == null ? new RtfColor(this.document, 255, 255, 255) : new RtfColor(this.document, cell.getBackgroundColor());
        this.cellPadding = (int)this.parentRow.getParentTable().getCellPadding();
        Iterator cellIterator = cell.getElements();
        Paragraph container = null;
        while (cellIterator.hasNext()) {
            try {
                int i;
                RtfBasicElement[] rtfElements;
                Element element = (Element)cellIterator.next();
                if (!(element instanceof Paragraph) && !(element instanceof List)) {
                    if (container != null) {
                        container.add((Object)element);
                        continue;
                    }
                    container = new Paragraph();
                    container.setAlignment(cell.getHorizontalAlignment());
                    container.add((Object)element);
                    continue;
                }
                if (container != null) {
                    rtfElements = this.document.getMapper().mapElement((Element)container);
                    for (i = 0; i < rtfElements.length; ++i) {
                        rtfElements[i].setInTable(true);
                        this.content.add(rtfElements[i]);
                    }
                    container = null;
                }
                if (element instanceof Paragraph && ((Paragraph)element).getAlignment() == -1) {
                    ((Paragraph)element).setAlignment(cell.getHorizontalAlignment());
                }
                rtfElements = this.document.getMapper().mapElement(element);
                for (i = 0; i < rtfElements.length; ++i) {
                    rtfElements[i].setInTable(true);
                    this.content.add(rtfElements[i]);
                }
            }
            catch (DocumentException de) {
                de.printStackTrace();
            }
        }
        if (container != null) {
            try {
                RtfBasicElement[] rtfElements = this.document.getMapper().mapElement((Element)container);
                for (int i = 0; i < rtfElements.length; ++i) {
                    rtfElements[i].setInTable(true);
                    this.content.add(rtfElements[i]);
                }
            }
            catch (DocumentException de) {
                de.printStackTrace();
            }
        }
    }

    private void importCell(PdfPCell cell) {
        PdfPTable table;
        Phrase phrase;
        Image img;
        this.content = new ArrayList();
        if (cell == null) {
            this.borders = new RtfBorderGroup(this.document, 2, this.parentRow.getParentTable().getBorders());
            return;
        }
        this.cellPadding = (int)this.parentRow.getParentTable().getCellPadding();
        this.cellPaddingBottom = cell.getPaddingBottom();
        this.cellPaddingTop = cell.getPaddingTop();
        this.cellPaddingRight = cell.getPaddingRight();
        this.cellPaddingLeft = cell.getPaddingLeft();
        this.borders = new RtfBorderGroup(this.document, 2, cell.getBorder(), cell.getBorderWidth(), cell.getBorderColor());
        this.border = cell.getBorder();
        this.borderColor = cell.getBorderColor();
        this.borderColorBottom = cell.getBorderColorBottom();
        this.borderColorTop = cell.getBorderColorTop();
        this.borderColorLeft = cell.getBorderColorLeft();
        this.borderColorRight = cell.getBorderColorRight();
        this.borderWidth = cell.getBorderWidth();
        this.borderWidthBottom = cell.getBorderWidthBottom();
        this.borderWidthTop = cell.getBorderWidthTop();
        this.borderWidthLeft = cell.getBorderWidthLeft();
        this.borderWidthRight = cell.getBorderWidthRight();
        this.colspan = cell.getColspan();
        this.rowspan = 1;
        this.verticalAlignment = cell.getVerticalAlignment();
        this.backgroundColor = cell.getBackgroundColor() == null ? new RtfColor(this.document, 255, 255, 255) : new RtfColor(this.document, cell.getBackgroundColor());
        java.util.List compositeElements = cell.getCompositeElements();
        if (compositeElements != null) {
            Iterator cellIterator = compositeElements.iterator();
            Paragraph container = null;
            while (cellIterator.hasNext()) {
                try {
                    int i;
                    RtfBasicElement[] rtfElements;
                    Element element = (Element)cellIterator.next();
                    if (!(element instanceof Paragraph) && !(element instanceof List)) {
                        if (container != null) {
                            container.add((Object)element);
                            continue;
                        }
                        container = new Paragraph();
                        container.setAlignment(cell.getHorizontalAlignment());
                        container.add((Object)element);
                        continue;
                    }
                    if (container != null) {
                        rtfElements = this.document.getMapper().mapElement((Element)container);
                        for (i = 0; i < rtfElements.length; ++i) {
                            rtfElements[i].setInTable(true);
                            this.content.add(rtfElements[i]);
                        }
                        container = null;
                    }
                    if (element instanceof Paragraph && ((Paragraph)element).getAlignment() == -1) {
                        ((Paragraph)element).setAlignment(cell.getHorizontalAlignment());
                    }
                    rtfElements = this.document.getMapper().mapElement(element);
                    for (i = 0; i < rtfElements.length; ++i) {
                        rtfElements[i].setInTable(true);
                        this.content.add(rtfElements[i]);
                    }
                }
                catch (DocumentException de) {
                    de.printStackTrace();
                }
            }
            if (container != null) {
                try {
                    RtfBasicElement[] rtfElements = this.document.getMapper().mapElement((Element)container);
                    for (int i = 0; i < rtfElements.length; ++i) {
                        rtfElements[i].setInTable(true);
                        this.content.add(rtfElements[i]);
                    }
                }
                catch (DocumentException de) {
                    de.printStackTrace();
                }
            }
        }
        if ((img = cell.getImage()) != null) {
            try {
                RtfBasicElement[] rtfElements = this.document.getMapper().mapElement((Element)img);
                for (int i = 0; i < rtfElements.length; ++i) {
                    rtfElements[i].setInTable(true);
                    this.content.add(rtfElements[i]);
                }
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        }
        if ((phrase = cell.getPhrase()) != null) {
            try {
                RtfBasicElement[] rtfElements = this.document.getMapper().mapElement((Element)phrase);
                for (int i = 0; i < rtfElements.length; ++i) {
                    rtfElements[i].setInTable(true);
                    this.content.add(rtfElements[i]);
                }
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        }
        if ((table = cell.getTable()) != null) {
            this.add(table);
        }
    }

    @Override
    public void writeDefinition(OutputStream result) throws IOException {
        if (this.mergeType == 1) {
            result.write(DocWriter.getISOBytes((String)"\\clvmgf"));
        } else if (this.mergeType == 2) {
            result.write(DocWriter.getISOBytes((String)"\\clvmrg"));
        }
        switch (this.verticalAlignment) {
            case 6: {
                result.write(DocWriter.getISOBytes((String)"\\clvertalb"));
                break;
            }
            case 1: 
            case 5: {
                result.write(DocWriter.getISOBytes((String)"\\clvertalc"));
                break;
            }
            case 4: {
                result.write(DocWriter.getISOBytes((String)"\\clvertalt"));
            }
        }
        this.borders.writeContent(result);
        if (this.backgroundColor != null) {
            result.write(DocWriter.getISOBytes((String)"\\clcbpat"));
            result.write(this.intToByteArray(this.backgroundColor.getColorNumber()));
        }
        this.document.outputDebugLinebreak(result);
        result.write(DocWriter.getISOBytes((String)"\\clftsWidth3"));
        this.document.outputDebugLinebreak(result);
        result.write(DocWriter.getISOBytes((String)"\\clwWidth"));
        result.write(this.intToByteArray(this.cellWidth));
        this.document.outputDebugLinebreak(result);
        if (this.cellPadding > 0) {
            result.write(DocWriter.getISOBytes((String)"\\clpadl"));
            result.write(this.intToByteArray(this.cellPadding / 2));
            result.write(DocWriter.getISOBytes((String)"\\clpadt"));
            result.write(this.intToByteArray(this.cellPadding / 2));
            result.write(DocWriter.getISOBytes((String)"\\clpadr"));
            result.write(this.intToByteArray(this.cellPadding / 2));
            result.write(DocWriter.getISOBytes((String)"\\clpadb"));
            result.write(this.intToByteArray(this.cellPadding / 2));
            result.write(DocWriter.getISOBytes((String)"\\clpadfl3"));
            result.write(DocWriter.getISOBytes((String)"\\clpadft3"));
            result.write(DocWriter.getISOBytes((String)"\\clpadfr3"));
            result.write(DocWriter.getISOBytes((String)"\\clpadfb3"));
        }
        result.write(DocWriter.getISOBytes((String)"\\cellx"));
        result.write(this.intToByteArray(this.cellRight));
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        if (this.content.size() == 0) {
            result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            if (this.parentRow.getParentTable().getTableFitToPage()) {
                result.write(RtfParagraphStyle.KEEP_TOGETHER_WITH_NEXT);
            }
            result.write(RtfParagraph.IN_TABLE);
        } else {
            for (int i = 0; i < this.content.size(); ++i) {
                RtfBasicElement rtfElement = (RtfBasicElement)this.content.get(i);
                if (rtfElement instanceof RtfParagraph) {
                    ((RtfParagraph)rtfElement).setKeepTogetherWithNext(this.parentRow.getParentTable().getTableFitToPage());
                }
                rtfElement.writeContent(result);
                if (!(rtfElement instanceof RtfParagraph) || i >= this.content.size() - 1) continue;
                result.write(RtfParagraph.PARAGRAPH);
            }
        }
        result.write(DocWriter.getISOBytes((String)"\\cell"));
    }

    protected void setCellRight(int cellRight) {
        this.cellRight = cellRight;
    }

    protected int getCellRight() {
        return this.cellRight;
    }

    protected void setCellWidth(int cellWidth) {
        this.cellWidth = cellWidth;
    }

    protected int getCellWidth() {
        return this.cellWidth;
    }

    protected int getCellpadding() {
        return this.cellPadding;
    }

    protected RtfBorderGroup getBorders() {
        return this.borders;
    }

    public void setBorders(RtfBorderGroup borderGroup) {
        this.borders = new RtfBorderGroup(this.document, 2, borderGroup);
    }

    protected RtfColor getRtfBackgroundColor() {
        return this.backgroundColor;
    }

    protected void setCellMergeChild(RtfCell mergeParent) {
        this.mergeType = 2;
        this.cellWidth = mergeParent.getCellWidth();
        this.cellRight = mergeParent.getCellRight();
        this.cellPadding = mergeParent.getCellpadding();
        this.borders = mergeParent.getBorders();
        this.verticalAlignment = mergeParent.getVerticalAlignment();
        this.backgroundColor = mergeParent.getRtfBackgroundColor();
    }

    @Override
    public void setRtfDocument(RtfDocument doc) {
        this.document = doc;
    }

    @Override
    public void setInTable(boolean inTable) {
    }

    @Override
    public void setInHeader(boolean inHeader) {
        this.inHeader = inHeader;
        for (int i = 0; i < this.content.size(); ++i) {
            ((RtfBasicElement)this.content.get(i)).setInHeader(inHeader);
        }
    }

    public boolean isInHeader() {
        return this.inHeader;
    }

    private byte[] intToByteArray(int i) {
        return DocWriter.getISOBytes((String)Integer.toString(i));
    }

    public boolean isDeleted() {
        return this.deleted;
    }
}

