/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.utils;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.YarfrawException;

public class FeedFormatDetector {
    private static final Log LOG = LogFactory.getLog(FeedFormatDetector.class);
    private static final String RSS = "rss";
    private static final String VERSION = "version";
    private static final String VERSION_20 = "2.0";
    private static final String RDF = "RDF";
    private static final String RDF_NS_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String ATOM10_XMLNS = "http://www.w3.org/2005/Atom";
    private static final String ATOM03_XMLNS = "http://purl.org/atom/ns#";
    private static final String FEED = "feed";
    private static final FormatDetectionHandler FormatDetectionHandler_NON_STRICT = new FormatDetectionHandler(false);
    private static final FormatDetectionHandler FormatDetectionHandler_STRICT = new FormatDetectionHandler(true);

    public static FeedFormat getFormat(InputStream stream) throws YarfrawException {
        return FeedFormatDetector.getFormat(stream, false);
    }

    public static FeedFormat getFormat(InputStream stream, boolean strictFormatDetection) throws YarfrawException {
        if (stream == null) {
            throw new IllegalArgumentException("Null stream received");
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(stream, (DefaultHandler)(strictFormatDetection ? FormatDetectionHandler_STRICT : FormatDetectionHandler_NON_STRICT));
            return FeedFormat.UNKNOWN;
        }
        catch (ParserConfigurationException e) {
            throw new YarfrawException("Format Detection Failed", e);
        }
        catch (EarlyTerminationException e) {
            return e.getFormat();
        }
        catch (SAXException e) {
            throw new YarfrawException("Format Detection Failed", e);
        }
        catch (IOException e) {
            throw new YarfrawException("Format Detection Failed", e);
        }
    }

    private static class EarlyTerminationException
    extends SAXException {
        private static final long serialVersionUID = 1L;
        private FeedFormat _format;

        public EarlyTerminationException(FeedFormat format) {
            this._format = format;
        }

        public FeedFormat getFormat() {
            return this._format;
        }
    }

    private static class FormatDetectionHandler
    extends DefaultHandler2 {
        private boolean _strict = false;

        public FormatDetectionHandler(boolean strict) {
            this._strict = strict;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws EarlyTerminationException {
            if (FeedFormatDetector.RSS.equals(localName)) {
                String version = attributes.getValue("", FeedFormatDetector.VERSION);
                if (!FeedFormatDetector.VERSION_20.equals(version)) {
                    if (!this._strict) {
                        LOG.warn((Object)("Input RSS feed is of version " + version + ", reading it as version 2.0. Version 2.0 should be backward compatibile"));
                    } else {
                        throw new EarlyTerminationException(FeedFormat.UNKNOWN);
                    }
                }
                throw new EarlyTerminationException(FeedFormat.RSS20);
            }
            if (FeedFormatDetector.RDF.equals(localName) && FeedFormatDetector.RDF_NS_URI.equals(uri)) {
                throw new EarlyTerminationException(FeedFormat.RSS10);
            }
            if (FeedFormatDetector.FEED.equals(localName) && FeedFormatDetector.ATOM10_XMLNS.equals(uri)) {
                throw new EarlyTerminationException(FeedFormat.ATOM10);
            }
            if (FeedFormatDetector.FEED.equals(localName) && FeedFormatDetector.ATOM03_XMLNS.equals(uri)) {
                throw new EarlyTerminationException(FeedFormat.ATOM03);
            }
            throw new EarlyTerminationException(FeedFormat.UNKNOWN);
        }
    }
}

