/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.documentsLists;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DocumentsListsService
extends DefaultComponent {
    public static final String NAME = "org.nuxeo.ecm.webapp.documentsLists.DocumentsListsService";
    private static final Log log = LogFactory.getLog(DocumentsListsService.class);
    private Map<String, DocumentsListDescriptor> descriptors;

    public DocumentsListDescriptor getDocumentsListDescriptor(String descriptorName) {
        return this.descriptors.get(descriptorName);
    }

    public List<String> getDocumentsListDescriptorsName() {
        ArrayList<String> list = new ArrayList<String>();
        for (String k : this.descriptors.keySet()) {
            if (!this.descriptors.get(k).getEnabled()) continue;
            list.add(k);
        }
        return list;
    }

    public void activate(ComponentContext context) {
        this.descriptors = new HashMap<String, DocumentsListDescriptor>();
    }

    public void deactivate(ComponentContext context) {
        this.descriptors = null;
    }

    private void mergeDescriptors(DocumentsListDescriptor newContrib) {
        DocumentsListDescriptor oldDescriptor = this.descriptors.get(newContrib.getName());
        oldDescriptor.setEnabled(newContrib.getEnabled());
        if (newContrib.getCategory() != null) {
            oldDescriptor.setCategory(newContrib.getCategory());
        }
        oldDescriptor.setSupportAppends(newContrib.getSupportAppends());
        oldDescriptor.setDefaultInCategory(newContrib.getDefaultInCategory());
        oldDescriptor.setIsSession(newContrib.getIsSession());
        oldDescriptor.setPersistent(newContrib.getPersistent());
        oldDescriptor.setEvenstName(newContrib.getEventsName());
        if (newContrib.getImageURL() != null) {
            oldDescriptor.setImageURL(newContrib.getImageURL());
        }
        oldDescriptor.setReadOnly(oldDescriptor.getReadOnly());
        if (newContrib.getTitle() != null) {
            oldDescriptor.setTitle(newContrib.getTitle());
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        DocumentsListDescriptor descriptor = (DocumentsListDescriptor)contribution;
        if (this.descriptors.containsKey(descriptor.getName())) {
            this.mergeDescriptors(descriptor);
            log.debug((Object)("merged DocumentsListDescriptor: " + descriptor.getName()));
        } else {
            this.descriptors.put(descriptor.getName(), descriptor);
            log.debug((Object)("registered DocumentsListDescriptor: " + descriptor.getName()));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        DocumentsListDescriptor descriptor = (DocumentsListDescriptor)contribution;
        this.descriptors.remove(descriptor.getName());
        log.debug((Object)("unregistered DocumentsListDescriptor: " + descriptor.getName()));
    }
}

