/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.notification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ec.notification.SubscriptionAdapter;
import org.nuxeo.ecm.platform.notification.api.NotificationManager;
import org.nuxeo.ecm.user.center.notification.UserSubscription;
import org.nuxeo.runtime.api.Framework;

@Name(value="userNotificationActions")
@Scope(value=ScopeType.CONVERSATION)
public class UserNotificationActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected NuxeoPrincipal currentUser;
    @In(create=true)
    protected CoreSession documentManager;
    @In(create=true)
    protected transient NotificationManager notificationManager;
    private List<UserSubscription> subscriptions;

    @Factory(value="userSubscriptions", scope=ScopeType.EVENT)
    public List<UserSubscription> getUserSubscriptions() {
        ArrayList<UserSubscription> result = new ArrayList<UserSubscription>();
        String prefixedUserName = "user:" + this.currentUser.getName();
        result.addAll(this.fetchSubscriptionsFor(prefixedUserName));
        for (String group : this.currentUser.getAllGroups()) {
            String prefixedgroupName = "group:" + group;
            result.addAll(this.fetchSubscriptionsFor(prefixedgroupName));
        }
        this.reorderSubscriptions(result);
        return this.subscriptions;
    }

    private List<UserSubscription> fetchSubscriptionsFor(String prefixedUserName) {
        ArrayList<UserSubscription> result = new ArrayList<UserSubscription>();
        NotificationManager nm = (NotificationManager)Framework.getService(NotificationManager.class);
        List subscribedDocs = nm.getSubscribedDocuments(prefixedUserName, this.documentManager.getRepositoryName());
        for (DocumentModel doc : subscribedDocs) {
            if (!this.documentManager.exists(doc.getRef())) continue;
            SubscriptionAdapter sa = (SubscriptionAdapter)doc.getAdapter(SubscriptionAdapter.class);
            List notifications = sa.getUserSubscriptions(prefixedUserName);
            for (String notification : notifications) {
                result.add(new UserSubscription(doc.getId(), notification, prefixedUserName));
            }
        }
        return result;
    }

    private void reorderSubscriptions(List<UserSubscription> allSubscriptions) {
        HashMap unsortedSubscriptions = new HashMap();
        for (UserSubscription obj : allSubscriptions) {
            UserSubscription us = obj;
            DocumentModel doc = this.getDocument(us.getDocId());
            String path = doc == null ? us.getDocId() : this.getDocument(us.getDocId()).getPathAsString();
            if (!unsortedSubscriptions.containsKey(path)) {
                unsortedSubscriptions.put(path, new ArrayList());
            }
            ((List)unsortedSubscriptions.get(path)).add(us);
        }
        TreeSet sortedset = new TreeSet(unsortedSubscriptions.keySet());
        this.subscriptions = new ArrayList<UserSubscription>();
        Iterator it = sortedset.iterator();
        while (it.hasNext()) {
            this.subscriptions.addAll((Collection)unsortedSubscriptions.get(it.next()));
        }
    }

    public DocumentModel getDocument(String docId) {
        IdRef ref = new IdRef(docId);
        if (this.documentManager.exists((DocumentRef)ref)) {
            return this.documentManager.getDocument((DocumentRef)ref);
        }
        return null;
    }

    public boolean getCanRemoveNotification(String userId) {
        return userId != null && userId.equals("user:" + this.currentUser.getName());
    }
}

