/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.versioning;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.facet.VersioningDocument;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.versioning.api.VersionIncEditOptions;
import org.nuxeo.ecm.platform.versioning.api.VersioningActions;
import org.nuxeo.ecm.platform.versioning.api.VersioningManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.versioning.DocumentVersioning;
import org.nuxeo.ecm.webapp.versioning.VersionInfo;

@Name(value="documentVersioning")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class DocumentVersioningBean
implements DocumentVersioning,
Serializable {
    private static final long serialVersionUID = 75409841629876L;
    private static final Log log = LogFactory.getLog(DocumentVersioningBean.class);
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    private transient VersioningManager versioningManager;
    private Boolean rendered;
    private VersioningActions selectedOption;

    @Override
    public Collection<VersionModel> getItemVersioningHistory(DocumentModel document) {
        List versions = Collections.emptyList();
        versions = this.documentManager.getVersionsForDocument(document.getRef());
        for (VersionModel model : versions) {
            DocumentModel ver = this.documentManager.getDocumentWithVersion(document.getRef(), model);
            if (ver == null) continue;
            model.setDescription(((VersioningDocument)ver.getAdapter(VersioningDocument.class)).getVersionLabel());
        }
        return versions;
    }

    @Override
    public Collection<VersionModel> getCurrentItemVersioningHistory() {
        return this.getItemVersioningHistory(this.navigationContext.getCurrentDocument());
    }

    @Factory(autoCreate=true, value="currentDocumentVersionInfo", scope=ScopeType.EVENT)
    public VersionInfo getCurrentDocumentVersionInfo() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (doc == null) {
            return null;
        }
        String versionLabel = this.versioningManager.getVersionLabel(doc);
        boolean available = versionLabel != null && versionLabel.length() != 0;
        return new VersionInfo(versionLabel, available);
    }

    @Observer(value={"documentSelectionChanged", "documentChanged"}, create=false)
    @BypassInterceptors
    public void resetVersioningOption() {
        this.selectedOption = null;
        this.rendered = null;
    }

    @Override
    public Map<String, String> getVersioningOptionsMap(DocumentModel doc) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        VersionIncEditOptions options = this.getAvailableVersioningOptions(doc);
        if (options != null) {
            for (VersioningActions option : options.getOptions()) {
                String label = "label.versioning.option." + option.toString();
                if (this.resourcesAccessor != null) {
                    label = (String)this.resourcesAccessor.getMessages().get(label);
                }
                map.put(option.name(), label);
            }
        }
        return map;
    }

    public VersionIncEditOptions getAvailableVersioningOptions(DocumentModel doc) {
        return this.versioningManager.getVersionIncEditOptions(doc);
    }

    @Override
    public String getVersionLabel(DocumentModel doc) {
        return this.versioningManager.getVersionLabel(doc);
    }

    @Override
    public void validateOptionSelection(FacesContext context, UIComponent component, Object value) {
        if (value != null) {
            return;
        }
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        String msg = I18NUtils.getMessageString((String)bundleName, (String)"error.versioning.none_selected", null, (Locale)locale);
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
        throw new ValidatorException(message);
    }
}

