/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.oauth2;

import java.util.Arrays;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.admin.oauth.DirectoryBasedEditor;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2Client;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2ClientService;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.runtime.api.Framework;

@Name(value="oauth2ClientsActions")
@Scope(value=ScopeType.CONVERSATION)
public class OAuth2ClientsActions
extends DirectoryBasedEditor {
    private static final long serialVersionUID = 1L;

    @Override
    protected String getDirectoryName() {
        return "oauth2Clients";
    }

    @Override
    protected String getSchemaName() {
        return "oauth2Client";
    }

    public void validateRedirectURIs(FacesContext context, UIComponent component, Object value) {
        List<String> redirectURIs;
        if (!(value instanceof String)) {
            this.handleValidationError(context, "label.oauth2.missing.redirectURI");
        }
        if ((redirectURIs = Arrays.asList(((String)value).split(","))).isEmpty()) {
            this.handleValidationError(context, "label.oauth2.missing.redirectURI");
        }
        redirectURIs.stream().map(String::trim).forEach(redirectURI -> {
            if (redirectURI.isEmpty()) {
                this.handleValidationError(context, "label.oauth2.empty.redirectURI");
            }
            if (!OAuth2Client.isRedirectURIValid((String)redirectURI)) {
                this.handleValidationError(context, "label.oauth2.invalid.redirectURIs");
            }
        });
    }

    protected void handleValidationError(FacesContext context, String label) {
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)label), null);
        throw new ValidatorException(message);
    }

    public void validateClientId(FacesContext context, UIComponent component, Object value) {
        OAuth2ClientService clientService = (OAuth2ClientService)Framework.getService(OAuth2ClientService.class);
        if (value instanceof String && clientService.hasClient((String)value)) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.oauth2.existing.clientId"), null);
            throw new ValidatorException(message);
        }
    }
}

