/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.jsf;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.connect.client.jsf.AppCenterViewsManager;
import org.nuxeo.connect.client.status.ConnectStatusHolder;
import org.nuxeo.connect.client.status.ConnectUpdateStatusInfo;
import org.nuxeo.connect.client.status.SubscriptionStatusWrapper;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.data.SubscriptionStatusType;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.identity.TechnicalInstanceIdentifier;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.runtime.api.Framework;

@Name(value="connectStatus")
@Scope(value=ScopeType.CONVERSATION)
public class ConnectStatusActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CLIENT_BANNER_TYPE = "clientSideBanner";
    public static final String SERVER_BANNER_TYPE = "serverSideBanner";
    private static final Log log = LogFactory.getLog(ConnectStatusActionBean.class);
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true, required=true, value="appsViews")
    protected AppCenterViewsManager appsViews;
    @In(create=true)
    protected Map<String, String> messages;
    protected String CLID;
    protected String token;
    protected ConnectUpdateStatusInfo connectionStatusCache;
    protected Blob packageToUpload;
    protected String packageFileName;

    public String getRegistredCLID() throws LogicalInstanceIdentifier.NoCLID {
        if (this.isRegistered()) {
            return LogicalInstanceIdentifier.instance().getCLID();
        }
        return null;
    }

    public String getCLID() {
        return this.CLID;
    }

    public void setCLID(String cLID) {
        this.CLID = cLID;
    }

    public String unregister() {
        LogicalInstanceIdentifier.cleanUp();
        this.resetRegister();
        return null;
    }

    public List<SelectItem> getInstanceTypes() {
        ArrayList<SelectItem> types = new ArrayList<SelectItem>();
        for (NuxeoClientInstanceType itype : NuxeoClientInstanceType.values()) {
            SelectItem item = new SelectItem((Object)itype.getValue(), "label.instancetype." + itype.getValue());
            types.add(item);
        }
        return types;
    }

    protected ConnectRegistrationService getService() {
        return (ConnectRegistrationService)Framework.getLocalService(ConnectRegistrationService.class);
    }

    @Factory(scope=ScopeType.APPLICATION, value="registredConnectInstance")
    public boolean isRegistered() {
        return this.getService().isInstanceRegistered();
    }

    @Deprecated
    public boolean isRegistred() {
        return this.isRegistered();
    }

    protected void flushContextCache() {
        Contexts.getApplicationContext().remove("registredConnectInstance");
        Contexts.getApplicationContext().remove("connectUpdateStatusInfo");
        this.appsViews.flushCache();
    }

    @Factory(value="connectServerReachable", scope=ScopeType.EVENT)
    public boolean isConnectServerReachable() {
        return !ConnectStatusHolder.instance().getStatus().isConnectServerUnreachable();
    }

    public String refreshStatus() {
        ConnectStatusHolder.instance().getStatus(true);
        this.flushContextCache();
        return null;
    }

    public SubscriptionStatusWrapper getStatus() {
        return ConnectStatusHolder.instance().getStatus();
    }

    public String resetRegister() {
        this.flushContextCache();
        return null;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) throws IOException, LogicalInstanceIdentifier.InvalidCLID {
        if (token != null) {
            String[] tokenDataLines;
            String tokenData = new String(Base64.decodeBase64((String)token));
            for (String line : tokenDataLines = tokenData.split("\n")) {
                String[] parts = line.split(":");
                if (parts.length <= 1 || !"CLID".equals(parts[0])) continue;
                this.getService().localRegisterInstance(parts[1], " ");
                this.connectionStatusCache = null;
                this.flushContextCache();
                ConnectStatusHolder.instance().flush();
            }
        }
    }

    public String getCTID() {
        try {
            return TechnicalInstanceIdentifier.instance().getCTID();
        }
        catch (Exception e) {
            throw ExceptionUtils.runtimeException((Exception)e);
        }
    }

    public String localRegister() {
        try {
            this.getService().localRegisterInstance(this.CLID, "");
        }
        catch (LogicalInstanceIdentifier.InvalidCLID e) {
            this.facesMessages.addToControl("offline_clid", StatusMessage.Severity.WARN, this.messages.get("label.connect.wrongCLID"), new Object[0]);
        }
        catch (IOException e) {
            this.facesMessages.addToControl("offline_clid", StatusMessage.Severity.ERROR, this.messages.get("label.connect.registrationError"), new Object[0]);
            log.error((Object)"Error while registering instance locally", (Throwable)e);
        }
        this.flushContextCache();
        return null;
    }

    public String getPackageFileName() {
        return this.packageFileName;
    }

    public void setPackageFileName(String packageFileName) {
        this.packageFileName = packageFileName;
    }

    public Blob getPackageToUpload() {
        return this.packageToUpload;
    }

    public void setPackageToUpload(Blob packageToUpload) {
        this.packageToUpload = packageToUpload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadPackage() throws IOException {
        if (this.packageToUpload == null) {
            this.facesMessages.add(StatusMessage.Severity.WARN, "label.connect.nofile", new Object[0]);
            return;
        }
        PackageUpdateService pus = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
        try (CloseableFile cfile = this.packageToUpload.getCloseableFile();){
            pus.addPackage(cfile.getFile());
        }
        catch (PackageException e) {
            log.warn((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("label.connect.wrong.package") + ":" + e.getMessage(), new Object[0]);
            return;
        }
        finally {
            this.packageFileName = null;
            this.packageToUpload = null;
        }
    }

    public ConnectUpdateStatusInfo getDynamicConnectUpdateStatusInfo() {
        HttpServletRequest req = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String bannerType = req.getParameter("bannerType");
        if ("unregistered".equals(bannerType)) {
            return ConnectUpdateStatusInfo.unregistered();
        }
        if ("notreachable".equals(bannerType)) {
            return ConnectUpdateStatusInfo.connectServerUnreachable();
        }
        if ("notvalid".equals(bannerType)) {
            return ConnectUpdateStatusInfo.notValid();
        }
        if ("ok".equals(bannerType)) {
            return ConnectUpdateStatusInfo.ok();
        }
        return this.getConnectUpdateStatusInfo();
    }

    @Factory(scope=ScopeType.APPLICATION, value="connectBannerEnabled")
    public boolean isConnectBannerEnabled() {
        String testerName = Framework.getProperty((String)"org.nuxeo.ecm.tester.name");
        return testerName == null || !testerName.equals("Nuxeo-Selenium-Tester");
    }

    @Factory(scope=ScopeType.APPLICATION, value="connectUpdateStatusInfo")
    public ConnectUpdateStatusInfo getConnectUpdateStatusInfo() {
        if (this.connectionStatusCache == null) {
            this.connectionStatusCache = !this.isRegistered() ? ConnectUpdateStatusInfo.unregistered() : (this.isConnectBannerEnabled() && this.isConnectServerReachable() ? (this.getStatus().isError() ? ConnectUpdateStatusInfo.connectServerUnreachable() : (ConnectStatusHolder.instance().getStatus().status() == SubscriptionStatusType.OK ? ConnectUpdateStatusInfo.ok() : ConnectUpdateStatusInfo.notValid())) : ConnectUpdateStatusInfo.connectServerUnreachable());
        }
        return this.connectionStatusCache;
    }

    @Factory(value="nuxeoConnectUrl")
    public String getConnectServerUrl() {
        return ConnectUrlConfig.getBaseUrl();
    }
}

