/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.logs.viewer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="logsViewerActions")
@Install(precedence=10)
public class LogsViewerActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LOG_MAX_LINES_COUNT_KEY = "nuxeo.logs.viewer.max.lines.count";
    public static final int LOG_MAX_LINES_COUNT = 1500;
    protected long logMaxLinesCount = -1L;
    protected List<String> logFiles;
    protected String selectedLogFile;
    protected long selectedLogFileLastModified = -1L;
    protected List<LogLine> initialLogLines;
    protected long bytesRead = 0L;

    public long getLogMaxLinesCount() {
        if (this.logMaxLinesCount == -1L) {
            ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
            this.logMaxLinesCount = Integer.parseInt(cs.getProperty(LOG_MAX_LINES_COUNT_KEY, String.valueOf(1500)), 10);
        }
        return this.logMaxLinesCount;
    }

    public List<String> getLogFiles() {
        if (this.logFiles == null) {
            File consoleLog;
            ConfigurationGenerator configurationGenerator = new ConfigurationGenerator();
            configurationGenerator.init();
            this.logFiles = new ArrayList<String>(configurationGenerator.getLogFiles());
            File nuxeoctlLog = new File(configurationGenerator.getLogDir(), "nuxeoctl.log");
            if (nuxeoctlLog.exists()) {
                this.logFiles.add(nuxeoctlLog.getAbsolutePath());
            }
            if ((consoleLog = new File(configurationGenerator.getLogDir(), "console.log")).exists()) {
                this.logFiles.add(consoleLog.getAbsolutePath());
            }
        }
        return this.logFiles;
    }

    public String getSelectedLogFile() {
        List<String> logFiles;
        if (this.selectedLogFile == null && !(logFiles = this.getLogFiles()).isEmpty()) {
            this.selectedLogFile = logFiles.get(0);
            this.selectedLogFileLastModified = -1L;
        }
        return this.selectedLogFile;
    }

    public void setSelectedLogFile(String selectedLogFile) {
        this.flushCache();
        this.selectedLogFile = selectedLogFile;
    }

    public String getFileName(String logFile) {
        return FilenameUtils.getName((String)logFile);
    }

    public List<LogLine> getInitialLogLines() throws IOException {
        if (this.initialLogLines == null) {
            File logFile;
            this.initialLogLines = new ArrayList<LogLine>();
            String selectedLogFile = this.getSelectedLogFile();
            if (selectedLogFile != null && (logFile = new File(selectedLogFile)).exists()) {
                try (ReversedLinesFileReader reversedLinesFileReader = new ReversedLinesFileReader(new File(this.getSelectedLogFile()));){
                    String line;
                    int i = 0;
                    while ((long)i < this.getLogMaxLinesCount() && (line = reversedLinesFileReader.readLine()) != null) {
                        this.initialLogLines.add(0, new LogLine(line));
                        ++i;
                    }
                }
                this.bytesRead = logFile.length();
                this.selectedLogFileLastModified = logFile.lastModified();
            }
        }
        return this.initialLogLines;
    }

    @Factory(value="newLogLines", scope=ScopeType.EVENT)
    public List<LogLine> getNewLogLines() throws IOException {
        File logFile;
        ArrayList<LogLine> logLines = new ArrayList<LogLine>();
        String selectedLogFile = this.getSelectedLogFile();
        if (selectedLogFile != null && (logFile = new File(selectedLogFile)).exists() && logFile.lastModified() > this.selectedLogFileLastModified) {
            if (this.bytesRead > logFile.length()) {
                this.bytesRead = 0L;
            }
            try (BufferedReader in = new BufferedReader(new FileReader(logFile));){
                String line;
                in.skip(this.bytesRead);
                while ((line = in.readLine()) != null) {
                    logLines.add(new LogLine(line));
                }
            }
            this.bytesRead = logFile.length();
            this.selectedLogFileLastModified = logFile.lastModified();
        }
        return logLines;
    }

    public void downloadLogFile() throws IOException, OperationException {
        String selectedLogFile = this.getSelectedLogFile();
        if (selectedLogFile == null) {
            return;
        }
        File logFile = new File(selectedLogFile);
        if (logFile.exists()) {
            Blob blob = Blobs.createBlob((File)logFile);
            OperationChain chain = new OperationChain("DownloadServerLogFile");
            chain.add("WebUI.DownloadFile");
            try (OperationContext ctx = new OperationContext();){
                ctx.setInput((Object)blob);
                ((AutomationService)Framework.getLocalService(AutomationService.class)).run(ctx, chain);
            }
        }
    }

    public void flushCache() {
        this.initialLogLines = null;
        this.selectedLogFileLastModified = -1L;
        this.bytesRead = 0L;
    }

    public static class LogLine {
        protected String line;
        protected Status status;

        public LogLine(String line) {
            this.line = line;
            this.status = LogLine.computeStatus(line);
        }

        public String getLine() {
            return this.line;
        }

        public Status getStatus() {
            return this.status;
        }

        protected static Status computeStatus(String line) {
            Status status = Status.UNKNOWN;
            if (line.matches(".* INFO .*")) {
                status = Status.INFO;
            } else if (line.matches(".* DEBUG .*")) {
                status = Status.DEBUG;
            } else if (line.matches(".* WARN .*")) {
                status = Status.WARN;
            } else if (line.matches(".* ERROR .*")) {
                status = Status.ERROR;
            }
            return status;
        }

        public static enum Status {
            INFO,
            DEBUG,
            WARN,
            ERROR,
            UNKNOWN;

        }
    }
}

