/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.aws.textract;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.textract.AmazonTextract;
import com.amazonaws.services.textract.AmazonTextractClientBuilder;
import com.amazonaws.services.textract.model.AnalyzeDocumentRequest;
import com.amazonaws.services.textract.model.AnalyzeDocumentResult;
import com.amazonaws.services.textract.model.DetectDocumentTextRequest;
import com.amazonaws.services.textract.model.DetectDocumentTextResult;
import com.amazonaws.services.textract.model.Document;
import com.amazonaws.services.textract.model.S3Object;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.labs.aws.textract.TextractUtils;
import org.nuxeo.runtime.api.Framework;

public class TextractService {
    protected String bucket;
    protected String bucketPrefix;
    protected String region;
    protected AmazonTextract textractClient;
    protected static TextractService instance = null;
    protected static int checkS3BlobProviderClass = -1;
    protected boolean forceS3Key = false;
    List<String> DEFAULT_ANALYZE_FEATURES = List.of("TABLES", "FORMS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextractService getInstance(String bucket, String bucketPrefix, String region) {
        if (instance != null) return instance;
        Class<TextractService> clazz = TextractService.class;
        synchronized (TextractService.class) {
            if (instance != null) return instance;
            instance = new TextractService(bucket, bucketPrefix, region);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    public void setForceS3Key(boolean value) {
        this.forceS3Key = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextractService getInstance() {
        if (instance != null) return instance;
        Class<TextractService> clazz = TextractService.class;
        synchronized (TextractService.class) {
            if (instance != null) return instance;
            instance = new TextractService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TextractService(String bucket, String bucketPrefix, String region) {
        this.bucket = bucket;
        this.bucketPrefix = bucketPrefix;
        if (StringUtils.isNotBlank((CharSequence)bucketPrefix)) {
            if (!bucketPrefix.endsWith("/")) {
                this.bucketPrefix = this.bucketPrefix + "/";
            }
        } else {
            this.bucketPrefix = "binary_store/";
        }
        this.region = region;
        AwsClientBuilder.EndpointConfiguration endpoint = new AwsClientBuilder.EndpointConfiguration("https://textract." + region + ".amazonaws.com", region);
        this.textractClient = (AmazonTextract)((AmazonTextractClientBuilder)AmazonTextractClientBuilder.standard().withEndpointConfiguration(endpoint)).build();
    }

    private TextractService() {
        this(Framework.getProperty((String)"nuxeo.s3storage.bucket"), Framework.getProperty((String)"nuxeo.s3storage.bucket_prefix"), Framework.getProperty((String)"nuxeo.s3storage.region"));
    }

    public AnalyzeDocumentResult analyze(List<String> features, String blobKeyOnS3) {
        if (features == null || features.size() == 0) {
            features = this.DEFAULT_ANALYZE_FEATURES;
        }
        String s3Path = this.bucketPrefix + blobKeyOnS3;
        AnalyzeDocumentRequest request = new AnalyzeDocumentRequest().withFeatureTypes(features.toArray(new String[0])).withDocument(new Document().withS3Object(new S3Object().withName(s3Path).withBucket(this.bucket)));
        AnalyzeDocumentResult result = this.textractClient.analyzeDocument(request);
        return result;
    }

    protected boolean hasS3BlobProviderClass() {
        if (checkS3BlobProviderClass == -1) {
            try {
                Class<?> theClass = Class.forName("org.nuxeo.ecm.blob.s3.S3BlobProvider");
                checkS3BlobProviderClass = 1;
            }
            catch (ClassNotFoundException e) {
                checkS3BlobProviderClass = 0;
            }
        }
        return checkS3BlobProviderClass == 1;
    }

    protected String getS3BlobKey(Blob blob) {
        if (blob instanceof ManagedBlob && (this.hasS3BlobProviderClass() || this.forceS3Key)) {
            int seppos;
            ManagedBlob managedBlob = (ManagedBlob)blob;
            String key = managedBlob.getKey();
            int colon = key.indexOf(58);
            if (colon >= 0) {
                key = key.substring(colon + 1);
            }
            if ((seppos = key.indexOf(64)) >= 0) {
                key = key.substring(0, seppos);
            }
            return key;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public AnalyzeDocumentResult analyze(List<String> features, Blob blob) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String analyzeGetText(TextractUtils.Granularity granularity, List<String> features, Blob blob) {
        AnalyzeDocumentResult result = this.analyze(features, blob);
        String text = TextractUtils.getAllTextJoined(() -> ((AnalyzeDocumentResult)result).getBlocks(), granularity, "\n");
        return text;
    }

    public String analyzeGetRawResultJsonString(List<String> features, Blob blob) {
        AnalyzeDocumentResult result = this.analyze(features, blob);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.valueToTree((Object)result);
        return jsonNode.toString();
    }

    public DetectDocumentTextResult detectDocumentText(String blobKeyOnS3) {
        String s3Path = this.bucketPrefix + blobKeyOnS3;
        DetectDocumentTextRequest request = new DetectDocumentTextRequest().withDocument(new Document().withS3Object(new S3Object().withName(s3Path).withBucket(this.bucket)));
        DetectDocumentTextResult result = this.textractClient.detectDocumentText(request);
        return result;
    }

    /*
     * Exception decompiling
     */
    public DetectDocumentTextResult detectDocumentText(Blob blob) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String detectDocumentTextGetText(TextractUtils.Granularity granularity, Blob blob) {
        DetectDocumentTextResult result = this.detectDocumentText(blob);
        String text = TextractUtils.getAllTextJoined(() -> ((DetectDocumentTextResult)result).getBlocks(), granularity, "\n");
        return text;
    }

    public String detectDocumentTextGetRawResultJsonString(Blob blob) {
        DetectDocumentTextResult result = this.detectDocumentText(blob);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.valueToTree((Object)result);
        return jsonNode.toString();
    }
}

