/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.aws.textract;

import com.amazonaws.services.textract.model.Block;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.pdf.PDFInfo;
import org.nuxeo.ecm.platform.pdf.PDFPageExtractor;

public class TextractUtils {
    private TextractUtils() {
    }

    public static List<String> getAllText(Supplier<List<Block>> blocksSupplier, Granularity granularity) {
        List blocks = Objects.requireNonNullElseGet(blocksSupplier.get(), List::of);
        String wanted = granularity.name();
        return blocks.stream().filter(b -> wanted.equals(b.getBlockType())).map(Block::getText).filter(Objects::nonNull).filter(text -> !text.matches("\\p{Punct}+")).collect(Collectors.toCollection(LinkedHashSet::new)).stream().toList();
    }

    public static String getAllTextJoined(Supplier<List<Block>> blocksSupplier, Granularity granularity, String separator) {
        return String.join((CharSequence)separator, TextractUtils.getAllText(blocksSupplier, granularity));
    }

    public static String removeDuplicates(String input, String separator) {
        if (StringUtils.isBlank((CharSequence)separator)) {
            separator = "\n";
        }
        LinkedHashSet seen = new LinkedHashSet();
        String result = Arrays.stream(input.split("\\R")).filter(line -> seen.add(line.toLowerCase())).collect(Collectors.joining(separator));
        return result;
    }

    public static BlobList splitPDFIfMoreThanOnePage(Blob blob) {
        String mimeType = blob.getMimeType();
        int pages = 0;
        BlobList blobList = new BlobList();
        if ("application/pdf".equals(mimeType)) {
            PDFInfo pdfInfo = new PDFInfo(blob);
            pdfInfo.run();
            pages = pdfInfo.getNumberOfPages();
            if (pages > 1) {
                PDFPageExtractor pe = new PDFPageExtractor(blob);
                for (int i = 1; i <= pages; ++i) {
                    Blob onePage = pe.extract(i, i);
                    blobList.add((Object)onePage);
                }
            }
        }
        return blobList;
    }

    public static void deleteFilesSilently(BlobList blobList) {
        for (Blob oneBlob : blobList) {
            try {
                oneBlob.getFile().delete();
            }
            catch (Exception exception) {}
        }
    }

    public static enum Granularity {
        WORD,
        LINE;

    }
}

