/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.service.enrichment;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.labs.hyland.content.intelligence.AuthenticationTokenParams;

@XObject(value="knowledgeEnrichment")
public class KEDescriptor {
    private static final Logger log = LogManager.getLogger(KEDescriptor.class);
    @XNode(value="name")
    protected String name = null;
    @XNode(value="authenticationBaseUrl")
    protected String authenticationBaseUrl = null;
    @XNode(value="baseUrl")
    protected String baseUrl = null;
    @XNode(value="tokenGrantType")
    protected String tokenGrantType = null;
    @XNode(value="tokenScope")
    protected String tokenScope = null;
    @XNode(value="clientId")
    protected String clientId = null;
    @XNode(value="clientSecret")
    protected String clientSecret = null;
    protected AuthenticationTokenParams authTokenParams = null;

    public String getName() {
        return this.name;
    }

    public String getAuthenticationBaseUrl() {
        return this.authenticationBaseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public AuthenticationTokenParams getAuthenticationTokenParams() {
        if (this.authTokenParams == null) {
            this.authTokenParams = new AuthenticationTokenParams(this.tokenGrantType, this.tokenScope, this.clientId, this.clientSecret, null);
        }
        return this.authTokenParams;
    }

    public boolean hasAllValues() {
        return !StringUtils.isBlank((CharSequence)this.authenticationBaseUrl) && !StringUtils.isBlank((CharSequence)this.baseUrl) && !StringUtils.isBlank((CharSequence)this.tokenGrantType) && !StringUtils.isBlank((CharSequence)this.tokenScope) && !StringUtils.isBlank((CharSequence)this.clientId) && !StringUtils.isBlank((CharSequence)this.clientSecret);
    }

    public void checkConfigAndLogErrors() {
        if (StringUtils.isBlank((CharSequence)this.authenticationBaseUrl)) {
            log.warn("No CIC Authentication endpoint provided for configuration '" + this.name + "', authentication to the service will fail.");
        }
        if (StringUtils.isBlank((CharSequence)this.baseUrl)) {
            log.warn("No CIC Enrichment endpoint provided for configuration '" + this.name + "', calls to the service will fail.");
        }
        if (StringUtils.isBlank((CharSequence)this.tokenGrantType)) {
            log.warn("No CIC Enrichment tokenGrantType provided in the configuration '" + this.name + "', authentication to the service will fail.");
        }
        if (StringUtils.isBlank((CharSequence)this.tokenScope)) {
            log.warn("No CIC Enrichment tokenScope provided in the configuration '" + this.name + "', authentication to the service will fail.");
        }
        if (StringUtils.isBlank((CharSequence)this.clientId)) {
            log.warn("No CIC Enrichment ClientId provided for configuration '" + this.name + "', authentication to the service will fail.");
        }
        if (StringUtils.isBlank((CharSequence)this.clientSecret)) {
            log.warn("No CIC Enrichment clientSecret provided for configuration '" + this.name + "', authentication to the service will fail.");
        }
    }
}

