/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.http;

import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.NuxeoException;

public class ServiceCallResult {
    protected String response;
    protected int responseCode;
    protected String responseMessage;
    protected JSONArray objectKeysMapping = null;

    public ServiceCallResult(String response, int responseCode, String responseMessage) {
        this.response = response;
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
    }

    public ServiceCallResult(String response, int responseCode, String responseMessage, JSONArray objectKeysMapping) {
        this.response = response;
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.objectKeysMapping = objectKeysMapping;
    }

    public ServiceCallResult(String jsonStr) {
        JSONObject obj = new JSONObject(jsonStr);
        this.response = obj.getJSONObject("response").toString();
        this.responseCode = obj.getInt("responseCode");
        this.responseMessage = obj.getString("responseMessage");
        this.objectKeysMapping = obj.getJSONArray("objectKeysMapping");
    }

    public JSONObject toJsonObject() {
        JSONObject obj = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)this.response)) {
            if (this.response.startsWith("[")) {
                obj.put("response", (Object)new JSONArray(this.response));
            } else {
                obj.put("response", (Object)new JSONObject(this.response));
            }
        } else if (ServiceCallResult.isHttpSuccess(this.responseCode)) {
            obj.put("response", (Object)new JSONObject("{\"errorMessage\": \"Empty string as response\"}"));
        } else {
            obj.put("response", (Object)new JSONObject("{}"));
        }
        obj.put("responseCode", this.responseCode);
        obj.put("responseMessage", (Object)(this.responseMessage == null ? "" : this.responseMessage));
        obj.put("objectKeysMapping", (Object)this.objectKeysMapping);
        return obj;
    }

    public String toJsonString() {
        return this.toJsonString(0);
    }

    public String toJsonString(int indentFactor) {
        JSONObject obj = this.toJsonObject();
        return obj.toString(indentFactor);
    }

    public String getResponse() {
        String result = StringUtils.removeStart((String)this.response, (String)"\"");
        result = StringUtils.removeEnd((String)result, (String)"\"");
        return result;
    }

    public JSONObject getResponseAsJSONObject() {
        if (this.response != null && !this.response.startsWith("{") && !this.response.startsWith("[")) {
            throw new NuxeoException("response is a simple string, cannot be converted to JSON Object. Call getResponse() instead.");
        }
        return new JSONObject(this.response);
    }

    public JSONObject forceResponseAsJSONObject() {
        if (this.response == null) {
            String resultStr = "{\"result\": null}";
            return new JSONObject(resultStr);
        }
        if (this.response.startsWith("{") || this.response.startsWith("[")) {
            JSONObject responseJson = new JSONObject(this.response);
            JSONObject result = new JSONObject();
            result.put("result", (Object)responseJson);
            return result;
        }
        Object resultStr = "{\"result\":";
        resultStr = this.response.startsWith("\"") ? (String)resultStr + this.response : "\"" + this.response + "\"";
        resultStr = (String)resultStr + "}";
        return new JSONObject((String)resultStr);
    }

    public void setObjectKeysMapping(JSONArray mapping) {
        this.objectKeysMapping = mapping;
    }

    public JSONArray getObjectKeysMapping() {
        return this.objectKeysMapping;
    }

    public JSONArray getResponseAsJSONArray() {
        if (this.response != null && !this.response.startsWith("[")) {
            throw new NuxeoException("response is a simple string, cannot be converted to JSON Array. Call getResponse() instead.");
        }
        return new JSONArray(this.response);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public boolean callWasSuccesful() {
        return ServiceCallResult.isHttpSuccess(this.responseCode);
    }

    public boolean callResponseOK() {
        return this.responseCode == 200;
    }

    public boolean callFailed() {
        return !ServiceCallResult.isHttpSuccess(this.responseCode);
    }

    public static boolean isHttpOk(int statusCode) {
        return statusCode == 200;
    }

    public static boolean isHttpSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }
}

