/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.discovery.automation;

import java.util.Map;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;
import org.nuxeo.labs.hyland.content.intelligence.service.ServicesUtils;
import org.nuxeo.labs.hyland.content.intelligence.service.discovery.HylandKDService;

@Operation(id="HylandKnowledgeDiscovery.Invoke", category="Hyland Knowledge Discovery", label="Call Hyland Knowledge Discovery Service", description="Invoke the Hyland Content Intelligence/Discovery API. Used for the low-level calls. (See Discovery API documentation for details). The result will have a 'responseCode' property that you should check, and the returned result is in the 'response' property. configName is the name of the XML configuration to use (if not passed, using 'default')")
public class HylandKDInvokeOp {
    public static final String ID = "HylandKnowledgeDiscovery.Invoke";
    @Context
    protected HylandKDService kdService;
    @Param(name="httpMethod", required=true)
    protected String httpMethod;
    @Param(name="endpoint", required=true)
    protected String endpoint;
    @Param(name="jsonPayloadStr", required=false)
    protected String jsonPayloadStr;
    @Param(name="extraHeadersJsonStr", required=false)
    protected String extraHeadersJsonStr;
    @Param(name="configName", required=false)
    protected String configName;

    @OperationMethod
    public Blob run() {
        Map<String, String> extraHeaders = ServicesUtils.jsonObjectStrToMap(this.extraHeadersJsonStr);
        ServiceCallResult result = this.kdService.invokeDiscovery(this.configName, this.httpMethod, this.endpoint, this.jsonPayloadStr, extraHeaders);
        return Blobs.createJSONBlob((String)result.toJsonString());
    }
}

