/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.enrichment.automation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.labs.hyland.content.intelligence.ContentToProcess;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;
import org.nuxeo.labs.hyland.content.intelligence.service.enrichment.HylandKEService;

@Operation(id="HylandKnowledgeEnrichment.EnrichSeveral", category="Hyland Knowledge Enrichment", label="CIC Knowledge Enrichement on Blobs or documents", description="Invoke the Hyland Knowledge Enrichment (KE) API to enrich the input documents/blobs. actions is a list of actions to process (image-description, image-embeddings, \u2026), classes a list of values to be used for classification, and similarValues is used for metadata endpoint. (See KE documentation for details, limitation, etc.) If input is Documents, use xpath to tell the operation where to find the blobs. To map the 'objectKey' returned by the service with your blobs, use the sourceIds param (comma separated list of unique valued). If input is a list od Documents and sourceIds is not passed, then we use the document UUIDs as 'sourceId'.  See the documentation for details. configName is the name of the XML configuration to use (if not passed, using 'default'). For KE V2 compatibility, if you want to pass the 'instructions' object, pass it in the extraJsonPayloadStr, as an object of objects, one per action (if instructions are requested). See plugin doc.")
public class HylandKEEnrichSeveralOp {
    public static final String ID = "HylandKnowledgeEnrichment.EnrichSeveral";
    @Context
    protected HylandKEService keService;
    @Param(name="actions", required=true)
    protected String actions;
    @Param(name="classes", required=false)
    protected String classes;
    @Param(name="similarMetadataJsonArrayStr", required=false)
    protected String similarMetadataJsonArrayStr;
    @Param(name="extraJsonPayloadStr", required=false)
    protected String extraJsonPayloadStr = null;
    @Param(name="xpath", required=false)
    protected String xpath = "file:content";
    @Param(name="sourceIds", required=false)
    protected String sourceIds;
    @Param(name="configName", required=false)
    protected String configName;

    @OperationMethod
    public Blob run(DocumentModelList docs) {
        BlobList blobs = new BlobList();
        if (StringUtils.isBlank((CharSequence)this.sourceIds)) {
            ArrayList<String> ids = new ArrayList<String>();
            for (DocumentModel doc : docs) {
                ids.add(doc.getId());
            }
            this.sourceIds = String.join((CharSequence)",", ids);
        }
        for (DocumentModel doc : docs) {
            blobs.add((Object)((Blob)doc.getPropertyValue(this.xpath)));
        }
        return this.run(blobs);
    }

    @OperationMethod
    public Blob run(BlobList blobs) {
        ServiceCallResult result;
        if (StringUtils.isBlank((CharSequence)this.sourceIds)) {
            throw new NuxeoException("sourceIds is required.");
        }
        List<String> sourceIdsArray = Arrays.stream(this.sourceIds.split(",")).map(String::trim).toList();
        if (sourceIdsArray.size() != blobs.size()) {
            throw new NuxeoException("The number od IDs in sourceIds is different than the number of blobs.");
        }
        ArrayList<ContentToProcess> contentToProcess = new ArrayList<ContentToProcess>();
        int idx = -1;
        for (Blob blob : blobs) {
            ContentToProcess<Blob> oneContent = new ContentToProcess<Blob>(sourceIdsArray.get(++idx), blob);
            contentToProcess.add(oneContent);
        }
        List<String> theActions = Arrays.stream(this.actions.split(",")).map(String::trim).toList();
        List<String> theClasses = null;
        if (StringUtils.isNotBlank((CharSequence)this.classes)) {
            theClasses = Arrays.stream(this.classes.split(",")).map(String::trim).toList();
        }
        try {
            result = this.keService.enrich(this.configName, contentToProcess, theActions, theClasses, this.similarMetadataJsonArrayStr, this.extraJsonPayloadStr);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        return Blobs.createJSONBlob((String)result.toJsonString());
    }
}

