/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.enrichment.automation;

import java.io.IOException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;
import org.nuxeo.labs.hyland.content.intelligence.service.enrichment.HylandKEService;

@Operation(id="HylandKnowledgeEnrichment.GetEnrichmentResults", category="Hyland Knowledge Enrichment", label="CIC Knowledge Enrichement Get Results", description="Invoke the Hyland Knowledge Enrichment (KE) API to get the processing results. Pass in jobId the value received after a call to the HylandKnowledgeEnrichment.SendForEnrichment operation. configName is the name of the XML configuration to use (if not passed, using 'default')")
public class HylandKEGetEnrichmentResultsOp {
    public static final String ID = "HylandKnowledgeEnrichment.GetEnrichmentResults";
    @Context
    protected HylandKEService keService;
    @Param(name="jobId", required=true)
    protected String jobId;
    @Param(name="configName", required=false)
    protected String configName;

    @OperationMethod
    public Blob run() {
        ServiceCallResult result;
        try {
            result = this.keService.getJobIdResult(this.configName, this.jobId);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        return Blobs.createJSONBlob((String)result.toJsonString());
    }
}

