/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.automation;

import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.labs.hyland.content.intelligence.service.agents.HylandAgentsService;
import org.nuxeo.labs.hyland.content.intelligence.service.discovery.HylandKDService;
import org.nuxeo.labs.hyland.content.intelligence.service.enrichment.HylandKEService;

@Operation(id="HylandContentIntelligence.GetContributionNames", category="Hyland Content Intelligence Connector", label="Get the names of all contributions", description="Returns a JSON object (as string) with the names of the extension points and for exah of them, the name of the contriutions.")
public class HylandCIGetContributionNamesOp {
    public static final String ID = "HylandContentIntelligence.GetContributionNames";
    @Context
    protected HylandKEService keService;
    @Context
    protected HylandKDService kdService;
    @Context
    protected HylandAgentsService agentsService;

    @OperationMethod
    public Blob run() {
        JSONObject result = new JSONObject();
        List<String> contribs = this.keService.getKEContribNames();
        JSONArray contribsJson = new JSONArray(contribs);
        result.put("knowledgeEnrichment", (Object)contribsJson);
        contribs = this.keService.getDCContribNames();
        contribsJson = new JSONArray(contribs);
        result.put("dataCuration", (Object)contribsJson);
        contribs = this.kdService.getKDContribNames();
        contribsJson = new JSONArray(contribs);
        result.put("knowledgeDiscovery", (Object)contribsJson);
        contribs = this.agentsService.getAgentContribNames();
        contribsJson = new JSONArray(contribs);
        result.put("agents", (Object)contribsJson);
        return Blobs.createJSONBlob((String)result.toString());
    }
}

