/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.nuxeo.labs.hyland.content.intelligence.service.enrichment.HylandKEService;
import org.nuxeo.runtime.api.Framework;

public class ServicesUtils {
    private static final Logger log = LogManager.getLogger(ServicesUtils.class);

    public static Map<String, String> jsonObjectStrToMap(String jsonObjectStr) {
        if (StringUtils.isBlank((CharSequence)jsonObjectStr)) {
            return null;
        }
        JSONObject jsonObject = new JSONObject(jsonObjectStr);
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            map.put(key, jsonObject.getString(key));
        }
        return map;
    }

    public static int configParamToInt(String param, int defaultValue) {
        int value;
        String paramValue = Framework.getProperty((String)param, (String)("" + defaultValue));
        try {
            value = Integer.parseInt(paramValue);
        }
        catch (NumberFormatException e) {
            log.error("Parameter <" + param + "> is not a valid integer. Using default value");
            value = defaultValue;
        }
        return value;
    }

    public static boolean configParamToBoolean(String param, boolean defaultValue) {
        boolean value;
        String paramValue = Framework.getProperty((String)param, (String)("" + defaultValue));
        try {
            value = Boolean.parseBoolean(paramValue);
        }
        catch (NumberFormatException e) {
            log.error("Parameter <" + param + "> is not a valid boolean. Using default value");
            value = defaultValue;
        }
        return value;
    }

    public static String addInstructionsToExtraPayload(String instructionsV2JsonStr, String extraPayloadJsonStr) {
        if (StringUtils.isBlank((CharSequence)instructionsV2JsonStr)) {
            return extraPayloadJsonStr;
        }
        HylandKEService keService = (HylandKEService)Framework.getService(HylandKEService.class);
        if (!keService.getUseKEV2()) {
            return extraPayloadJsonStr;
        }
        JSONObject extraPayload = null;
        extraPayload = StringUtils.isBlank((CharSequence)extraPayloadJsonStr) ? new JSONObject() : new JSONObject(extraPayloadJsonStr);
        extraPayload.put("instructions", (Object)new JSONObject(instructionsV2JsonStr));
        return extraPayload.toString();
    }
}

