/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.enrichment.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.labs.hyland.content.intelligence.service.enrichment.HylandKEService;

@Operation(id="HylandKnowledgeEnrichment.Configure", category="Hyland Knowledge Enrichment", label="Configure Calls to Service", description="Allows for dynamically changing some settings when calling the service. maxTries and sleepIntervalMS: if a value is 0 => reset to configuration or default value. If -1 (or not passed) => do not change. useKEV2 allows for setting the format/behavior when calling KE (it can also be set with the nuxeo.hyland.cic.enrichment.v2 config. param)")
public class ConfigureServiceOp {
    public static final String ID = "HylandKnowledgeEnrichment.Configure";
    @Context
    protected HylandKEService keService;
    @Param(name="maxTries", required=false)
    protected Integer maxTries = null;
    @Param(name="sleepIntervalMS", required=false)
    protected Integer sleepIntervalMS = null;
    @Param(name="useKEV2", required=false)
    protected Boolean useKEV2 = null;

    @OperationMethod
    public void run() {
        this.keService.setPullResultsSettings(this.maxTries == null ? 1 : this.maxTries, this.sleepIntervalMS == null ? -1 : this.sleepIntervalMS);
        if (this.useKEV2 != null) {
            this.keService.setUseKEV2(this.useKEV2);
        }
    }
}

