/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.enrichment.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;
import org.nuxeo.labs.hyland.content.intelligence.service.enrichment.HylandKEService;

@Operation(id="HylandKnowledgeEnrichment.Invoke", category="Hyland Knowledge Enrichment", label="Call Hyland Knowledge Enrichment Service", description="Invoke the Hyland Content Intelligence/Knowledge Enrichment API. Used for the low-level calls. (See Knowledge Enrichment API documentation for details) configName is the name of the XML configuration to use (if not passed, using 'default')")
public class HylandKEInvokeOp {
    public static final String ID = "HylandKnowledgeEnrichment.Invoke";
    @Context
    protected HylandKEService keService;
    @Param(name="httpMethod", required=true)
    protected String httpMethod;
    @Param(name="endpoint", required=true)
    protected String endpoint;
    @Param(name="jsonPayload", required=false)
    protected String jsonPayload;
    @Param(name="configName", required=false)
    protected String configName;

    @OperationMethod
    public Blob run() {
        ServiceCallResult result = this.keService.invokeEnrichment(this.configName, this.httpMethod, this.endpoint, this.jsonPayload);
        return Blobs.createJSONBlob((String)result.toJsonString());
    }
}

