/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.service.agents;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;
import org.nuxeo.labs.hyland.content.intelligence.service.agents.AgentDescriptor;

public interface HylandAgentsService {
    public ServiceCallResult getAllAgents(String var1, Map<String, String> var2);

    public ServiceCallResult lookupAgent(String var1, String var2, String var3, Map<String, String> var4);

    public ServiceCallResult invokeAgent(AgentType var1, String var2, String var3, String var4, String var5, Map<String, String> var6);

    public List<String> getAgentContribNames();

    public AgentDescriptor getAgentDescriptor(String var1);

    public static JSONObject formatJsonPayloadForKDQuestion(String question, String contextObjectIdsJsonArrayStr, String guardrailsJsonArrayStr) {
        JSONObject message = new JSONObject();
        message.put("role", (Object)"user");
        message.put("content", (Object)question);
        JSONArray messages = new JSONArray();
        messages.put((Object)message);
        String hxqlQuery = null;
        if (StringUtils.isNotBlank((CharSequence)contextObjectIdsJsonArrayStr)) {
            JSONArray contextObjectIds = new JSONArray(contextObjectIdsJsonArrayStr);
            if (contextObjectIds.length() == 1) {
                hxqlQuery = "SELECT * FROM SysContent WHERE cin_id = '" + contextObjectIds.getString(0) + "'";
            } else {
                String ids = IntStream.range(0, contextObjectIds.length()).mapToObj(i -> "'" + contextObjectIds.getString(i) + "'").collect(Collectors.joining(", "));
                hxqlQuery = "SELECT * FROM SysContent WHERE cin_id IN (" + ids + ")";
            }
        }
        JSONArray guardrails = null;
        if (StringUtils.isNotBlank((CharSequence)guardrailsJsonArrayStr)) {
            guardrails = new JSONArray(guardrailsJsonArrayStr);
        }
        JSONObject payload = new JSONObject();
        payload.put("messages", (Object)messages);
        if (hxqlQuery != null) {
            payload.put("hxqlQuery", (Object)hxqlQuery);
        }
        if (guardrails != null) {
            payload.put("guardrails", (Object)guardrails);
        }
        return payload;
    }

    public static JSONObject simplifyResponse(JSONObject response) {
        JSONObject simplified;
        boolean hasMoreResults = false;
        try {
            JSONArray output = response.getJSONArray("output");
            hasMoreResults = output.length() > 1;
            JSONObject firstOutput = output.getJSONObject(0);
            JSONArray content = firstOutput.getJSONArray("content");
            hasMoreResults = hasMoreResults || content.length() > 1;
            String text = content.getJSONObject(0).getString("text");
            simplified = new JSONObject();
            simplified.put("text", (Object)text);
            JSONArray sources = new JSONArray();
            if (response.has("customOutputs")) {
                JSONObject customOutputs = response.getJSONObject("customOutputs");
                JSONArray sourceNodes = customOutputs.getJSONArray("sourceNodes");
                for (int i = 0; i < sourceNodes.length(); ++i) {
                    JSONObject value = sourceNodes.getJSONObject(i);
                    JSONObject oneSource = new JSONObject();
                    String objectId = value.getString("docId");
                    int index = objectId.indexOf("__");
                    if (index != -1 && index + 2 < objectId.length()) {
                        objectId = objectId.substring(index + 2);
                    }
                    oneSource.put("objectId", (Object)objectId);
                    oneSource.put("score", value.getDouble("score"));
                    sources.put((Object)oneSource);
                }
            }
            simplified.put("sources", (Object)sources);
            simplified.put("simplifiedProcessingSuccess", true);
            simplified.put("moreResults", hasMoreResults);
            if (hasMoreResults) {
                simplified.put("originalResponse", (Object)response);
            }
        }
        catch (Exception e) {
            simplified = new JSONObject();
            simplified.put("simplifiedProcessingSuccess", false);
            simplified.put("originalResponse", (Object)response);
        }
        return simplified;
    }

    public static enum AgentType {
        RAG,
        TASK,
        TOOL;

    }
}

