/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.service.enrichment;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.labs.hyland.content.intelligence.AuthenticationToken;
import org.nuxeo.labs.hyland.content.intelligence.AuthenticationTokenEnrichment;
import org.nuxeo.labs.hyland.content.intelligence.ContentToProcess;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCall;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;
import org.nuxeo.labs.hyland.content.intelligence.service.AbstractServiceDescriptor;
import org.nuxeo.labs.hyland.content.intelligence.service.ServicesUtils;
import org.nuxeo.labs.hyland.content.intelligence.service.enrichment.DCDescriptor;
import org.nuxeo.labs.hyland.content.intelligence.service.enrichment.HylandKEService;
import org.nuxeo.labs.hyland.content.intelligence.service.enrichment.KEDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class HylandKEServiceImpl
extends DefaultComponent
implements HylandKEService {
    private static final Logger log = LogManager.getLogger(HylandKEServiceImpl.class);
    public static final String KE_USE_V2_PARAM = "nuxeo.hyland.cic.enrichment.v2";
    public static final String KE_INSTRUCTIONS_OBJ_IN_EXTRA_PAYLOAD = "instructions";
    public static final String KE_MAX_WORD_COUNT_PROPERTY = "maxWordCount";
    public static final String ENRICHMENT_CLIENT_ID_PARAM = "nuxeo.hyland.cic.enrichment.clientId";
    public static final String ENRICHMENT_CLIENT_SECRET_PARAM = "nuxeo.hyland.cic.enrichment.clientSecret";
    public static final String DATA_CURATION_CLIENT_ID_PARAM = "nuxeo.hyland.cic.datacuration.clientId";
    public static final String DATA_CURATION_CLIENT_SECRET_PARAM = "nuxeo.hyland.cic.datacuration.clientSecret";
    public static final String AUTH_BASE_URL_PARAM = "nuxeo.hyland.cic.auth.baseUrl";
    public static final String AUTH_ENDPOINT = "/connect/token";
    public static final String CONTEXT_ENRICHMENT_BASE_URL_PARAM = "nuxeo.hyland.cic.contextEnrichment.baseUrl";
    public static final String DATA_CURATION_BASE_URL_PARAM = "nuxeo.hyland.cic.dataCuration.baseUrl";
    public static final String PULL_RESULTS_MAX_TRIES_PARAM = "nuxeo.hyland.cic.pullResultsMaxTries";
    public static final int PULL_RESULTS_MAX_TRIES_DEFAULT = 25;
    public static final String PULL_RESULTS_SLEEP_INTERVAL_PARAM = "nuxeo.hyland.cic.pullResultsSleepInterval";
    public static final int PULL_RESULTS_SLEEP_INTERVAL_DEFAULT = 5000;
    public static final String DATA_CURATION_PRESIGN_DEFAULT_OPTIONS = "{\"normalization\": {\"quotations\": true},\"chunking\": true,\"embedding\": true,\"json_schema\": \"PIPELINE\"}";
    public static final String CONTENT_INTELL_CACHE = "content_intelligence_cache";
    protected static Map<String, AuthenticationToken> enrichmentAuthTokens = null;
    protected static Map<String, AuthenticationToken> dataCurationAuthTokens = null;
    protected static int pullResultsMaxTries;
    protected static int pullResultsSleepIntervalMS;
    public static final String CUSTOM_ID_PREFIX = "CUSTOM_ID-";
    protected static ServiceCall serviceCall;
    protected static boolean useKEV2;
    protected static final String EXT_POINT_KE = "knowledgeEnrichment";
    protected static final String EXT_POINT_DC = "dataCuration";
    protected Map<String, KEDescriptor> keContribs = new HashMap<String, KEDescriptor>();
    protected Map<String, DCDescriptor> dcContribs = new HashMap<String, DCDescriptor>();
    public static final String CONFIG_DEFAULT = "default";

    public HylandKEServiceImpl() {
        this.initialize();
    }

    public int getPullResultsMaxTries() {
        return pullResultsMaxTries;
    }

    public int getPullResultsSleepIntervalMS() {
        return pullResultsSleepIntervalMS;
    }

    protected String getCustomUUID() {
        String uuid = UUID.randomUUID().toString();
        return CUSTOM_ID_PREFIX + uuid.substring(CUSTOM_ID_PREFIX.length());
    }

    protected void initialize() {
        pullResultsMaxTries = ServicesUtils.configParamToInt(PULL_RESULTS_MAX_TRIES_PARAM, 25);
        pullResultsSleepIntervalMS = ServicesUtils.configParamToInt(PULL_RESULTS_SLEEP_INTERVAL_PARAM, 5000);
        useKEV2 = ServicesUtils.configParamToBoolean(KE_USE_V2_PARAM, false);
        this.logConfigurationInfo();
    }

    protected void logConfigurationInfo() {
        String msg = "Startup configuration:\n  pullResultsMaxTries=" + pullResultsMaxTries;
        msg = msg + "\n  pullResultsSleepIntervalMS=" + pullResultsSleepIntervalMS;
        msg = msg + "\n  useKEV2=" + useKEV2;
        ServicesUtils.forceLogInfo(this.getClass(), msg);
    }

    protected String getKEToken(String configName) {
        if (StringUtils.isBlank((CharSequence)configName)) {
            configName = CONFIG_DEFAULT;
        }
        AuthenticationToken token = enrichmentAuthTokens.get(configName);
        return token.getToken();
    }

    protected String getDCToken(String configName) {
        if (StringUtils.isBlank((CharSequence)configName)) {
            configName = CONFIG_DEFAULT;
        }
        AuthenticationToken token = dataCurationAuthTokens.get(configName);
        return token.getToken();
    }

    @Override
    public void setUseKEV2(boolean value) {
        useKEV2 = value;
        this.logConfigurationInfo();
    }

    @Override
    public boolean getUseKEV2() {
        return useKEV2;
    }

    @Override
    public void setPullResultsSettings(int maxTries, int sleepIntervalMS) {
        switch (maxTries) {
            case 0: {
                pullResultsMaxTries = ServicesUtils.configParamToInt(PULL_RESULTS_MAX_TRIES_PARAM, 25);
                break;
            }
            case -1: {
                break;
            }
            default: {
                pullResultsMaxTries = maxTries;
            }
        }
        switch (sleepIntervalMS) {
            case 0: {
                pullResultsSleepIntervalMS = ServicesUtils.configParamToInt(PULL_RESULTS_SLEEP_INTERVAL_PARAM, 5000);
                break;
            }
            case -1: {
                break;
            }
            default: {
                pullResultsSleepIntervalMS = sleepIntervalMS;
            }
        }
        this.logConfigurationInfo();
    }

    @Override
    public ServiceCallResult getJobIdResult(String configName, String jobId) {
        ServiceCallResult result = null;
        result = this.invokeEnrichment(configName, "GET", "/content/process/" + jobId + "/results", null);
        return result;
    }

    @Override
    public ServiceCallResult sendForEnrichment(String configName, Blob blob, String sourceId, List<String> actions, List<String> classes, String similarMetadataJsonArrayStr, String extraJsonPayloadStr) throws IOException {
        if (StringUtils.isBlank((CharSequence)sourceId)) {
            sourceId = this.getCustomUUID();
        }
        ArrayList<ContentToProcess> contentToProcess = new ArrayList<ContentToProcess>();
        ContentToProcess<Blob> oneContent = new ContentToProcess<Blob>(sourceId, blob);
        contentToProcess.add(oneContent);
        ServiceCallResult result = this.sendForEnrichment(configName, contentToProcess, actions, classes, similarMetadataJsonArrayStr, extraJsonPayloadStr);
        return result;
    }

    @Override
    public ServiceCallResult sendForEnrichment(String configName, File file, String sourceId, String mimeType, List<String> actions, List<String> classes, String similarMetadataJsonArrayStr, String extraJsonPayloadStr) throws IOException {
        if (StringUtils.isBlank((CharSequence)sourceId)) {
            sourceId = this.getCustomUUID();
        }
        ArrayList<ContentToProcess> contentToProcess = new ArrayList<ContentToProcess>();
        ContentToProcess<File> oneContent = new ContentToProcess<File>(sourceId, file);
        contentToProcess.add(oneContent);
        ServiceCallResult result = this.sendForEnrichment(configName, contentToProcess, actions, classes, similarMetadataJsonArrayStr, extraJsonPayloadStr);
        return result;
    }

    @Override
    public ServiceCallResult sendForEnrichment(String configName, List<ContentToProcess> contentObjects, List<String> actions, List<String> classes, String similarMetadataJsonArrayStr, String extraJsonPayloadStr) throws IOException {
        ServiceCallResult result = null;
        for (ContentToProcess content : contentObjects) {
            String errMsg;
            result = this.invokeEnrichment(configName, "GET", "/files/upload/presigned-url?contentType=" + content.getMimeType().replace("/", "%2F"), null);
            if (result.callFailed()) {
                errMsg = "Failed getting a presigned URL for content ID <" + content.getSourceId() + ">, File name <" + content.getFile().getName() + ">.";
                log.error(errMsg);
                content.setErrorMessage(errMsg);
                content.setProcessingSuccess(false);
                continue;
            }
            JSONObject serviceResponse = result.getResponseAsJSONObject();
            String presignedUrl = serviceResponse.getString("presignedUrl");
            String objectKey = serviceResponse.getString("objectKey");
            content.setObjectKey(objectKey);
            result = serviceCall.uploadFileWithPut(content.getFile(), presignedUrl, content.getMimeType());
            if (result.callFailed()) {
                errMsg = "Failed uploading content ID <" + content.getSourceId() + ">, File name <\"\n" + content.getFile().getName() + ">.";
                log.error(errMsg);
                content.setErrorMessage(errMsg);
                content.setProcessingSuccess(false);
                continue;
            }
            content.setProcessingSuccess(true);
        }
        for (ContentToProcess content : contentObjects) {
            content.close();
        }
        List<String> objectKeys = contentObjects.stream().filter(ContentToProcess::isProcessingSuccess).map(ContentToProcess::getObjectKey).collect(Collectors.toList());
        JSONObject payload = this.buildProcessActionPayload(objectKeys, actions, classes, similarMetadataJsonArrayStr, extraJsonPayloadStr);
        result = this.invokeEnrichment(configName, "POST", "/content/process", payload.toString());
        return result;
    }

    @Override
    public ServiceCallResult enrich(String configName, List<ContentToProcess> contentObjects, List<String> actions, List<String> classes, String similarMetadataJsonArrayStr, String extraJsonPayloadStr) throws IOException {
        ServiceCallResult result = null;
        if (log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("HylandKEServiceImpl#enrich:");
            sb.append("\n  configName: ").append(StringUtils.isBlank((CharSequence)configName) ? CONFIG_DEFAULT : configName);
            sb.append("\n  contentObjects: ").append(contentObjects.stream().map(c -> c != null && c.getFile() != null ? c.getFile().getName() : "null").toList());
            sb.append("\n  actions: ").append(actions);
            sb.append("\n  classes: ").append(classes);
            sb.append("\n  similarMetadataJsonArrayStr: ").append(similarMetadataJsonArrayStr);
            sb.append("\n  extraJsonPayloadStr: ").append(extraJsonPayloadStr);
            log.info(sb.toString());
        }
        if ((result = this.sendForEnrichment(configName, contentObjects, actions, classes, similarMetadataJsonArrayStr, extraJsonPayloadStr)).callFailed()) {
            return result;
        }
        JSONObject serviceResponse = result.getResponseAsJSONObject();
        String resultId = serviceResponse.getString("processingId");
        if ((result = this.pullEnrichmentResults(configName, resultId)).callWasSuccesful()) {
            JSONObject response = result.getResponseAsJSONObject();
            if (!response.has("results")) {
                String msg = "No \"results\" key in the response. Did we get a final result? Original message: " + result.getResponseMessage();
                result = new ServiceCallResult(response.toString(), result.getResponseCode(), msg);
            } else {
                JSONArray results = response.getJSONArray("results");
                JSONArray mapping = new JSONArray();
                results.forEach(oneResult -> {
                    String objectKey = ((JSONObject)oneResult).getString("objectKey");
                    ContentToProcess found = contentObjects.stream().filter(content -> objectKey.equals(content.getObjectKey())).findFirst().orElse(null);
                    if (found != null) {
                        JSONObject obj = new JSONObject();
                        obj.put("sourceId", (Object)found.getSourceId());
                        obj.put("objectKey", (Object)objectKey);
                        mapping.put((Object)obj);
                    }
                });
                result.setObjectKeysMapping(mapping);
            }
        }
        return result;
    }

    @Override
    public ServiceCallResult enrich(String configName, Blob blob, List<String> actions, List<String> classes, String similarMetadataJsonArrayStr, String extraJsonPayloadStr) throws IOException {
        String sourceId = this.getCustomUUID();
        ArrayList<ContentToProcess> contentToProcess = new ArrayList<ContentToProcess>();
        ContentToProcess<Blob> oneContent = new ContentToProcess<Blob>(sourceId, blob);
        contentToProcess.add(oneContent);
        ServiceCallResult result = this.enrich(configName, contentToProcess, actions, classes, similarMetadataJsonArrayStr, extraJsonPayloadStr);
        return result;
    }

    protected JSONObject buildProcessActionPayload(List<String> objectKeys, List<String> actions, List<String> classes, String similarMetadataJsonArrayStr, String extraJsonPayloadStr) {
        JSONObject payload = new JSONObject();
        JSONObject extraJsonPayload = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)extraJsonPayloadStr)) {
            extraJsonPayload = new JSONObject(extraJsonPayloadStr);
        }
        Integer maxWordCount = extraJsonPayload.optIntegerObject(KE_MAX_WORD_COUNT_PROPERTY, null);
        if (useKEV2) {
            payload.put("version", (Object)"context.api/v2");
            JSONArray objKeysV2 = new JSONArray();
            for (String oneKey : objectKeys) {
                JSONObject oneKeyObj = new JSONObject();
                oneKeyObj.put("path", (Object)oneKey);
                objKeysV2.put((Object)oneKeyObj);
            }
            payload.put("objectKeys", (Object)objKeysV2);
            JSONObject instructions = extraJsonPayload.optJSONObject(KE_INSTRUCTIONS_OBJ_IN_EXTRA_PAYLOAD, new JSONObject());
            JSONObject actionsObj = new JSONObject();
            for (String oneAction : actions) {
                JSONObject oneActionObj = new JSONObject();
                switch (oneAction) {
                    case "textClassification": 
                    case "imageClassification": {
                        oneActionObj.put("Classes", (Object)new JSONArray(classes));
                        break;
                    }
                    case "imageMetadataGeneration": 
                    case "textMetadataGeneration": {
                        oneActionObj.put("kSimilarMetadata", (Object)new JSONArray(similarMetadataJsonArrayStr));
                        break;
                    }
                    case "imageDescription": 
                    case "textSummarization": {
                        if (maxWordCount == null) break;
                        oneActionObj.put(KE_MAX_WORD_COUNT_PROPERTY, (Object)maxWordCount);
                        break;
                    }
                }
                JSONObject oneActionInstructions = instructions.optJSONObject(oneAction);
                if (oneActionInstructions != null) {
                    oneActionObj.put(KE_INSTRUCTIONS_OBJ_IN_EXTRA_PAYLOAD, (Object)oneActionInstructions);
                }
                actionsObj.put(oneAction, (Object)oneActionObj);
            }
            payload.put("actions", (Object)actionsObj);
        } else {
            payload.put("objectKeys", (Object)new JSONArray(objectKeys));
            payload.put("actions", (Object)new JSONArray(actions));
            if (similarMetadataJsonArrayStr == null) {
                payload.put("kSimilarMetadata", (Object)new JSONArray());
            } else {
                payload.put("kSimilarMetadata", (Object)new JSONArray(similarMetadataJsonArrayStr));
            }
            if (classes == null) {
                payload.put("classes", (Object)new JSONArray());
            } else {
                payload.put("classes", (Object)new JSONArray(classes));
            }
        }
        if (!extraJsonPayload.isEmpty()) {
            for (String key : JSONObject.getNames((JSONObject)extraJsonPayload)) {
                if (useKEV2 && KE_INSTRUCTIONS_OBJ_IN_EXTRA_PAYLOAD.equals(key)) continue;
                payload.put(key, extraJsonPayload.get(key));
            }
        }
        return payload;
    }

    @Override
    public ServiceCallResult enrich(String configName, File file, String mimeType, List<String> actions, List<String> classes, String similarMetadataJsonArrayStr, String extraJsonPayloadStr) throws IOException {
        String sourceId = this.getCustomUUID();
        ArrayList<ContentToProcess> contentToProcess = new ArrayList<ContentToProcess>();
        ContentToProcess<File> oneContent = new ContentToProcess<File>(sourceId, file);
        contentToProcess.add(oneContent);
        ServiceCallResult result = this.enrich(configName, contentToProcess, actions, classes, similarMetadataJsonArrayStr, extraJsonPayloadStr);
        return result;
    }

    @Override
    public ServiceCallResult curate(String configName, Blob blob, String jsonOptions) throws IOException {
        try (CloseableFile closFile = blob.getCloseableFile();){
            ServiceCallResult serviceCallResult = this.curate(configName, closFile.getFile(), jsonOptions);
            return serviceCallResult;
        }
    }

    @Override
    public ServiceCallResult curate(String configName, File file, String jsonOptions) throws IOException {
        ServiceCallResult result;
        String jobId = null;
        String getUrl = null;
        String putUrl = null;
        String bearer = this.getDCToken(configName);
        if (StringUtils.isBlank((CharSequence)bearer)) {
            throw new NuxeoException("No authentication info for calling the Data Curation service, for configuration '" + configName + "'.");
        }
        DCDescriptor config = this.getDCDescriptor(configName);
        Object targetUrl = config.getBaseUrl();
        targetUrl = (String)targetUrl + "/presign";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "*/*");
        headers.put("Authorization", "Bearer " + bearer);
        if (StringUtils.isBlank((CharSequence)jsonOptions)) {
            jsonOptions = DATA_CURATION_PRESIGN_DEFAULT_OPTIONS;
        }
        if ((result = serviceCall.post((String)targetUrl, headers, jsonOptions)).callFailed()) {
            return result;
        }
        JSONObject jsonPresign = result.getResponseAsJSONObject();
        jobId = jsonPresign.getString("job_id");
        putUrl = jsonPresign.getString("put_url");
        getUrl = jsonPresign.getString("get_url");
        result = serviceCall.uploadFileWithPut(file, putUrl, "application/octet-stream");
        if (result.callFailed()) {
            return result;
        }
        result = this.pullDataCurationResults(configName, jobId, getUrl);
        return result;
    }

    protected ServiceCallResult pullEnrichmentResults(String configName, String resultId) {
        ServiceCallResult result;
        int count = 1;
        log.info("pullEnrichmentResults for Job ID '" + resultId + "'.");
        do {
            if (count > 1) {
                try {
                    Thread.sleep(pullResultsSleepIntervalMS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (count == pullResultsMaxTries) {
                log.warn("Pulling Enrichment results is taking time. This is the last try,  " + count + "/" + pullResultsMaxTries);
                continue;
            }
            if (count != 5 && (count <= 5 || (count - 5) % 2 != 0)) continue;
            log.warn("Pulling Enrichment results is taking time. This is the call #" + count + " (max calls: " + pullResultsMaxTries + ")");
            if (count != 5) continue;
            KEDescriptor config = this.getKEDescriptor(configName);
            log.warn("(Pulling job ID '" + resultId + "', configuration '" + config.getName() + "')");
        } while (!(result = this.getJobIdResult(configName, resultId)).callResponseOK() && ++count <= pullResultsMaxTries);
        return result;
    }

    protected ServiceCallResult pullDataCurationResults(String configName, String jobId, String getUrl) {
        ServiceCallResult result = null;
        int count = 1;
        if (StringUtils.isBlank((CharSequence)jobId) || StringUtils.isBlank((CharSequence)getUrl)) {
            throw new IllegalArgumentException("jobId and/or getUrl - presigned - is/are null");
        }
        DCDescriptor config = this.getDCDescriptor(configName);
        String targetUrl = config.getBaseUrl() + "/status/" + jobId;
        boolean gotIt = false;
        do {
            String bearer;
            if (count > 1) {
                try {
                    Thread.sleep(pullResultsSleepIntervalMS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (count > pullResultsMaxTries / 2) {
                log.warn("Pulling Data Curation results is taking time. This is the call #" + count + " (max calls: " + pullResultsMaxTries + ")");
            }
            if (StringUtils.isBlank((CharSequence)(bearer = this.getDCToken(configName)))) {
                throw new NuxeoException("No authentication info for calling the Data Curation service, for configuration '" + configName + "'.");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + bearer);
            result = serviceCall.get(targetUrl, headers);
            if (!result.callWasSuccesful()) continue;
            JSONObject resultJson = result.getResponseAsJSONObject();
            String responseJobId = resultJson.getString("jobId");
            if (!responseJobId.equals(jobId)) {
                String msg = "Received OK for a different jobID. Exoected jobId: " + jobId + ", received: " + responseJobId;
                log.warn(msg);
                result = new ServiceCallResult("{}", -2, msg);
                continue;
            }
            String status = resultJson.getString("status");
            if (status.toLowerCase().equals("done")) {
                result = serviceCall.get(getUrl, null);
                if (!result.callWasSuccesful()) continue;
                gotIt = true;
                continue;
            }
            log.info("Pulling Data Curation status for job " + jobId + ", status: " + status);
        } while (!gotIt && ++count <= pullResultsMaxTries);
        return result;
    }

    @Override
    public ServiceCallResult invokeEnrichment(String configName, String httpMethod, String endpoint, String jsonPayload) {
        ServiceCallResult result = null;
        String bearer = this.getKEToken(null);
        if (StringUtils.isBlank((CharSequence)bearer)) {
            throw new NuxeoException("No authentication info for calling the Enrichment service.");
        }
        KEDescriptor config = this.getKEDescriptor(configName);
        Object targetUrl = config.getBaseUrl();
        if (!endpoint.startsWith("/")) {
            targetUrl = (String)targetUrl + "/";
        }
        targetUrl = (String)targetUrl + endpoint;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "*/*");
        headers.put("Authorization", "Bearer " + bearer);
        if (endpoint.startsWith("/content/process")) {
            headers.put("Content-Type", "application/json");
        }
        switch (httpMethod = httpMethod.toUpperCase()) {
            case "GET": {
                result = serviceCall.get((String)targetUrl, headers);
                break;
            }
            case "POST": {
                result = serviceCall.post((String)targetUrl, headers, jsonPayload);
                break;
            }
            case "PUT": {
                result = serviceCall.put((String)targetUrl, headers, jsonPayload);
                break;
            }
            default: {
                throw new NuxeoException("Only GET, POST and PUT are supported.");
            }
        }
        return result;
    }

    @Override
    public List<String> getKEContribNames() {
        if (this.keContribs == null) {
            this.keContribs = new HashMap<String, KEDescriptor>();
        }
        return new ArrayList<String>(this.keContribs.keySet());
    }

    @Override
    public KEDescriptor getKEDescriptor(String configName) {
        if (StringUtils.isBlank((CharSequence)configName)) {
            configName = CONFIG_DEFAULT;
        }
        return this.keContribs.get(configName);
    }

    @Override
    public List<String> getDCContribNames() {
        if (this.dcContribs == null) {
            this.dcContribs = new HashMap<String, DCDescriptor>();
        }
        return new ArrayList<String>(this.dcContribs.keySet());
    }

    @Override
    public DCDescriptor getDCDescriptor(String configName) {
        if (StringUtils.isBlank((CharSequence)configName)) {
            configName = CONFIG_DEFAULT;
        }
        return this.dcContribs.get(configName);
    }

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    public void registerExtension(Extension extension) {
        block6: {
            Object[] contribs;
            block5: {
                super.registerExtension(extension);
                if (this.keContribs == null) {
                    this.keContribs = new HashMap<String, KEDescriptor>();
                }
                if (this.dcContribs == null) {
                    this.dcContribs = new HashMap<String, DCDescriptor>();
                }
                if (!EXT_POINT_KE.equals(extension.getExtensionPoint())) break block5;
                Object[] contribs2 = extension.getContributions();
                if (contribs2 == null) break block6;
                for (Object contrib : contribs2) {
                    KEDescriptor desc = (KEDescriptor)contrib;
                    this.keContribs.put(desc.getName(), desc);
                }
                break block6;
            }
            if (EXT_POINT_DC.equals(extension.getExtensionPoint()) && (contribs = extension.getContributions()) != null) {
                for (Object contrib : contribs) {
                    DCDescriptor desc = (DCDescriptor)contrib;
                    this.dcContribs.put(desc.getName(), desc);
                }
            }
        }
    }

    public void unregisterExtension(Extension extension) {
        block7: {
            block6: {
                super.unregisterExtension(extension);
                if (!EXT_POINT_KE.equals(extension.getExtensionPoint())) break block6;
                if (this.keContribs == null) {
                    return;
                }
                Object[] contribs = extension.getContributions();
                if (contribs == null) break block7;
                for (Object contrib : contribs) {
                    KEDescriptor desc = (KEDescriptor)contrib;
                    this.keContribs.remove(desc.getName());
                }
                break block7;
            }
            if (EXT_POINT_DC.equals(extension.getExtensionPoint())) {
                if (this.dcContribs == null) {
                    return;
                }
                Object[] contribs = extension.getContributions();
                if (contribs != null) {
                    for (Object contrib : contribs) {
                        DCDescriptor desc = (DCDescriptor)contrib;
                        this.dcContribs.remove(desc.getName());
                    }
                }
            }
        }
    }

    public void start(ComponentContext context) {
        AuthenticationTokenEnrichment token;
        AbstractServiceDescriptor desc;
        if (this.keContribs == null) {
            log.error("No configuration found for Knowledge Enrichement. Calls, if any, will fail.");
        } else {
            enrichmentAuthTokens = new HashMap<String, AuthenticationToken>();
            for (Map.Entry<String, KEDescriptor> entry : this.keContribs.entrySet()) {
                desc = entry.getValue();
                token = new AuthenticationTokenEnrichment(desc.getAuthenticationBaseUrl() + AUTH_ENDPOINT, desc.getAuthenticationTokenParams());
                enrichmentAuthTokens.put(desc.getName(), token);
                desc.checkConfigAndLogErrors();
            }
        }
        if (this.dcContribs == null) {
            log.error("No configuration found for Data Curation. Calls, if any, will fail.");
        } else {
            dataCurationAuthTokens = new HashMap<String, AuthenticationToken>();
            for (Map.Entry<String, AbstractServiceDescriptor> entry : this.dcContribs.entrySet()) {
                desc = (DCDescriptor)entry.getValue();
                token = new AuthenticationTokenEnrichment(desc.getAuthenticationBaseUrl() + AUTH_ENDPOINT, desc.getAuthenticationTokenParams());
                dataCurationAuthTokens.put(desc.getName(), token);
                desc.checkConfigAndLogErrors();
            }
        }
    }

    public void stop(ComponentContext context) throws InterruptedException {
    }

    static {
        serviceCall = new ServiceCall();
        useKEV2 = false;
    }
}

