/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.agents.automation;

import java.util.Map;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;
import org.nuxeo.labs.hyland.content.intelligence.service.ServicesUtils;
import org.nuxeo.labs.hyland.content.intelligence.service.agents.HylandAgentsService;

@Operation(id="HylandAgents.getAllAgents", category="Hyland Agent Builder", label="Get All Agents", description="Returns a JSON blob holding  the result of the call. Call its getString() method then JSON.parse(). See CIC documentation for values. The result will have a 'responseCode' property that you should check (must be 200), and the array of agents is in the 'response' property. You can also pass extra headers in extraHeadersJsonStr as a stringified Json object configName is the name of the XML configuration to use (if not passed, using 'default')")
public class HylandAgentsGetAllAgentsOp {
    public static final String ID = "HylandAgents.getAllAgents";
    @Context
    protected HylandAgentsService agentsService;
    @Param(name="extraHeadersJsonStr", required=false)
    protected String extraHeadersJsonStr;
    @Param(name="configName", required=false)
    protected String configName;

    @OperationMethod
    public Blob run() {
        Map<String, String> extraHeaders = ServicesUtils.jsonObjectStrToMap(this.extraHeadersJsonStr);
        ServiceCallResult result = this.agentsService.getAllAgents(this.configName, extraHeaders);
        return Blobs.createJSONBlob((String)result.toJsonString());
    }
}

