/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.service;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.labs.hyland.content.intelligence.AuthenticationTokenParams;

public abstract class AbstractServiceDescriptor {
    @XNode(value="name")
    protected String name;
    @XNode(value="authenticationBaseUrl")
    protected String authenticationBaseUrl;
    @XNode(value="baseUrl")
    protected String baseUrl;
    @XNode(value="tokenGrantType")
    protected String tokenGrantType;
    @XNode(value="tokenScope")
    protected String tokenScope;
    @XNode(value="clientId")
    protected String clientId;
    @XNode(value="clientSecret")
    protected String clientSecret;
    protected AuthenticationTokenParams authTokenParams;

    protected abstract Logger log();

    protected abstract String serviceLabel();

    protected abstract boolean requiresEnvironment();

    public abstract String getEnvironment();

    public String getName() {
        return this.name;
    }

    public String getAuthenticationBaseUrl() {
        return this.authenticationBaseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public AuthenticationTokenParams getAuthenticationTokenParams() {
        if (this.authTokenParams == null) {
            this.authTokenParams = new AuthenticationTokenParams(this.tokenGrantType, this.tokenScope, this.clientId, this.clientSecret, this.getEnvironment());
        }
        return this.authTokenParams;
    }

    public boolean hasAllValues() {
        if (StringUtils.isBlank((CharSequence)this.authenticationBaseUrl) || StringUtils.isBlank((CharSequence)this.baseUrl) || StringUtils.isBlank((CharSequence)this.tokenGrantType) || StringUtils.isBlank((CharSequence)this.tokenScope) || StringUtils.isBlank((CharSequence)this.clientId) || StringUtils.isBlank((CharSequence)this.clientSecret)) {
            return false;
        }
        return !this.requiresEnvironment() || !StringUtils.isBlank((CharSequence)this.getEnvironment());
    }

    public void checkConfigAndLogErrors() {
        String serviceLabel = this.serviceLabel();
        if (StringUtils.isBlank((CharSequence)this.authenticationBaseUrl)) {
            this.log().warn("No CIC Authentication endpoint provided for configuration '{}', authentication to {} will fail.", (Object)this.name, (Object)serviceLabel);
        }
        if (StringUtils.isBlank((CharSequence)this.baseUrl)) {
            this.log().warn("No CIC {} endpoint provided for configuration '{}', calls to the service will fail.", (Object)serviceLabel, (Object)this.name);
        }
        if (StringUtils.isBlank((CharSequence)this.tokenGrantType)) {
            this.log().warn("No CIC {} tokenGrantType provided for configuration '{}', authentication to the service will fail.", (Object)serviceLabel, (Object)this.name);
        }
        if (StringUtils.isBlank((CharSequence)this.tokenScope)) {
            this.log().warn("No CIC {} tokenScope provided for configuration '{}', authentication to the service will fail.", (Object)serviceLabel, (Object)this.name);
        }
        if (StringUtils.isBlank((CharSequence)this.clientId)) {
            this.log().warn("No CIC {} clientId provided for configuration '{}', authentication to the service will fail.", (Object)serviceLabel, (Object)this.name);
        }
        if (StringUtils.isBlank((CharSequence)this.clientSecret)) {
            this.log().warn("No CIC {} clientSecret provided for configuration '{}', authentication to the service will fail.", (Object)serviceLabel, (Object)this.name);
        }
        if (this.requiresEnvironment() && StringUtils.isBlank((CharSequence)this.getEnvironment())) {
            this.log().warn("No CIC {} environment provided for configuration '{}', calls to the service will fail.", (Object)serviceLabel, (Object)this.name);
        }
    }
}

