/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCall;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;

public class AuthenticationToken {
    private static final Logger log = LogManager.getLogger(AuthenticationToken.class);
    protected String token = null;
    protected Instant tokenExpiration = null;
    protected String authFullUrl;
    protected String clientId;
    protected String clientSecret;
    protected String environment;
    protected ServiceCall serviceCall = new ServiceCall();
    ServiceType serviceType;

    public AuthenticationToken(ServiceType serviceType, String authFullUrl, String clientId, String clientSecret) {
        this.serviceType = serviceType;
        this.authFullUrl = authFullUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public AuthenticationToken(ServiceType serviceType, String authFullUrl, String clientId, String clientSecret, String environment) {
        this.serviceType = serviceType;
        this.authFullUrl = authFullUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.environment = environment;
    }

    public String getToken() {
        String postData;
        if (StringUtils.isNotBlank((CharSequence)this.token) && !Instant.now().isAfter(this.tokenExpiration)) {
            return this.token;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "*/*");
        headers.put("Accept-Encoding", "gzip, deflate, br");
        if (this.serviceType == ServiceType.DISCOVERY) {
            headers.put("hxp-environment", this.environment);
        }
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        try {
            postData = "client_id=" + URLEncoder.encode(this.clientId, "UTF-8") + "&client_secret=" + URLEncoder.encode(this.clientSecret, "UTF-8") + "&grant_type=client_credentials";
            switch (this.serviceType) {
                case ENRICHMENT: {
                    postData = postData + "&scope=environment_authorization";
                    break;
                }
                case DISCOVERY: {
                    postData = postData + "&scope=" + URLEncoder.encode("hxp hxp.integrations hxp.nucleus.account hxpr hxps", "UTF-8");
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new NuxeoException("Failed to encode the request", (Throwable)e);
        }
        ServiceCallResult result = this.serviceCall.post(this.authFullUrl, headers, postData);
        if (result.callWasSuccesful()) {
            JSONObject serviceResponse = result.getResponseAsJSONObject();
            if (serviceResponse.has("error")) {
                String msg = "Getting a token failed with error " + serviceResponse.getString("error") + ".";
                if (serviceResponse.has("error_description")) {
                    msg = msg + " " + serviceResponse.getString("error_description");
                }
                log.error(msg);
            } else {
                this.token = serviceResponse.getString("access_token");
                int expiresIn = serviceResponse.getInt("expires_in");
                this.tokenExpiration = Instant.now().plusSeconds(expiresIn - 15);
            }
        } else {
            log.error("Error getting an auth token:\n" + result.toJsonString(2));
            this.token = null;
        }
        return this.token;
    }

    public static enum ServiceType {
        ENRICHMENT,
        DISCOVERY;

    }
}

