/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public class ContentToProcess<T>
implements Closeable {
    private static final Logger log = LogManager.getLogger(ContentToProcess.class);
    protected String sourceId;
    protected Blob blob;
    protected File file;
    protected CloseableFile closeableFile;
    protected String mimeType;
    protected String objectKey;
    protected boolean processingSuccess;
    protected String errorMessage;

    public ContentToProcess(String sourceId, T content) {
        this.sourceId = sourceId;
        if (content instanceof Blob) {
            this.blob = (Blob)content;
        } else if (content instanceof File) {
            this.file = (File)content;
        } else {
            throw new IllegalArgumentException("Expecting Blob or File");
        }
        this.updateMimeType();
    }

    public ContentToProcess(String sourceId, T content, String mimeType) {
        this.sourceId = sourceId;
        if (content instanceof Blob) {
            this.blob = (Blob)content;
        } else if (content instanceof File) {
            this.file = (File)content;
        } else {
            throw new IllegalArgumentException("Expecting Blob or File");
        }
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            this.updateMimeType();
        } else {
            this.mimeType = mimeType;
        }
    }

    protected void updateMimeType() {
        MimetypeRegistry registry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        if (this.blob != null) {
            this.mimeType = this.blob.getMimeType();
            if (StringUtils.isBlank((CharSequence)this.mimeType)) {
                this.mimeType = registry.getMimetypeFromBlob(this.blob);
            }
        } else {
            this.mimeType = registry.getMimetypeFromFile(this.file);
        }
    }

    @Override
    public void close() {
        if (this.closeableFile != null) {
            try {
                this.closeableFile.close();
            }
            catch (IOException e) {
                Object fileName = "";
                File f = this.closeableFile.getFile();
                if (f != null) {
                    fileName = "<" + f.getName() + ">";
                }
                log.error("Failed to close the CloseableFile " + (String)fileName, (Throwable)e);
            }
            this.closeableFile = null;
        }
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public Blob getBlob() {
        return this.blob;
    }

    public File getFile() {
        if (this.file != null) {
            return this.file;
        }
        File f = this.blob.getFile();
        if (f == null) {
            try {
                this.closeableFile = this.blob.getCloseableFile();
                f = this.closeableFile.getFile();
            }
            catch (IOException e) {
                throw new NuxeoException("Failed to get a CloseableFile", (Throwable)e);
            }
        }
        return f;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean isProcessingSuccess() {
        return this.processingSuccess;
    }

    public void setProcessingSuccess(boolean processingSuccess) {
        this.processingSuccess = processingSuccess;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

