/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.service.enrichment;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="knowledgeEnrichment")
public class KEDescriptor {
    private static final Logger log = LogManager.getLogger(KEDescriptor.class);
    @XNode(value="name")
    protected String name = null;
    @XNode(value="authenticationBaseUrl")
    protected String authenticationBaseUrl = null;
    @XNode(value="baseUrl")
    protected String baseUrl = null;
    @XNode(value="clientId")
    protected String clientId = null;
    @XNode(value="clientSecret")
    protected String clientSecret = null;

    public String getName() {
        return this.name;
    }

    public String getAuthenticationBaseUrl() {
        return this.authenticationBaseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void checkConfigAndLogErrors() {
        if (StringUtils.isBlank((CharSequence)this.authenticationBaseUrl)) {
            log.warn("No CIC Authentication endpoint provided for configuration '" + this.name + "', calls to the service will fail.");
        }
        if (StringUtils.isBlank((CharSequence)this.baseUrl)) {
            log.warn("No CIC Enrichment endpoint provided for configuration '" + this.name + "', calls to the service will fail.");
        }
        if (StringUtils.isBlank((CharSequence)this.clientId)) {
            log.warn("No CIC Enrichment ClientId provided for configuration '" + this.name + "', calls to the service will fail.");
        }
        if (StringUtils.isBlank((CharSequence)this.clientSecret)) {
            log.warn("No CIC Enrichment clientSecret provided for configuration '" + this.name + "', calls to the service will fail.");
        }
    }
}

