/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.agents.automation;

import java.util.Map;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;
import org.nuxeo.labs.hyland.content.intelligence.service.ServicesUtils;
import org.nuxeo.labs.hyland.content.intelligence.service.agents.HylandAgentsService;

@Operation(id="HylandAgents.InvokeTaskAgent", category="Hyland Agent Builder", label="Invoke Task Agent", description="Returns a JSON blob holding the result of the call. Call its getString() method then JSON.parse(). See CIC documentation for values. The result will have a 'responseCode' property that you should check (must be 200), and the response of the agent in the 'response' object. agentVersion is optional. If not used, latest version is invoked. jsonPayloadStr is required: the expected JSON input (as string) for the agent. You can also pass extra headers in extraHeadersJsonStr as a stringified Json object configName is the name of the XML configuration to use (if not passed, using 'default')")
public class HylandAgentsInvokeTaskOp {
    public static final String ID = "HylandAgents.InvokeTaskAgent";
    @Context
    protected HylandAgentsService agentsService;
    @Param(name="configName", required=false)
    protected String configName;
    @Param(name="agentId", required=true)
    protected String agentId;
    @Param(name="agentVersion", required=false)
    protected String agentVersion;
    @Param(name="jsonPayloadStr", required=true)
    protected String jsonPayloadStr;
    @Param(name="extraHeadersJsonStr", required=false)
    protected String extraHeadersJsonStr;

    @OperationMethod
    public Blob run() {
        Map<String, String> extraHeaders = ServicesUtils.jsonObjectStrToMap(this.extraHeadersJsonStr);
        ServiceCallResult result = this.agentsService.invokeAgent(HylandAgentsService.AgentType.TASK, this.configName, this.agentId, this.agentVersion, this.jsonPayloadStr, extraHeaders);
        return Blobs.createJSONBlob((String)result.toJsonString());
    }
}

