/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;

public class ServiceCall {
    private static final Logger log = LogManager.getLogger(ServiceCall.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceCallResult get(String url, Map<String, String> headers) {
        ServiceCallResult result = null;
        HttpURLConnection connection = null;
        try {
            URL theUrl = new URI(url).toURL();
            connection = (HttpURLConnection)theUrl.openConnection();
            connection.setRequestMethod("GET");
            if (headers != null) {
                headers.forEach(connection::setRequestProperty);
            }
            result = this.readResponse(connection);
        }
        catch (IOException | URISyntaxException e) {
            log.error("Error: " + e.getMessage());
            result = new ServiceCallResult("{}", -1, e.getClass().getSimpleName() + ": " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
                connection = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceCallResult postOrPut(String httpMethod, String url, Map<String, String> headers, String body) {
        ServiceCallResult result = null;
        HttpURLConnection connection = null;
        try {
            URL theUrl = new URI(url).toURL();
            connection = (HttpURLConnection)theUrl.openConnection();
            connection.setRequestMethod(httpMethod);
            if (headers != null) {
                headers.forEach(connection::setRequestProperty);
            }
            connection.setDoOutput(true);
            if (body != null) {
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = body.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
            }
            result = this.readResponse(connection);
        }
        catch (IOException | URISyntaxException e) {
            log.error("Error: " + e.getMessage());
            result = new ServiceCallResult("{}", -1, e.getClass().getSimpleName() + ": " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
                connection = null;
            }
        }
        return result;
    }

    public ServiceCallResult post(String url, Map<String, String> headers, String body) {
        ServiceCallResult result = this.postOrPut("POST", url, headers, body);
        return result;
    }

    public ServiceCallResult put(String url, Map<String, String> headers, String body) {
        ServiceCallResult result = this.postOrPut("PUT", url, headers, body);
        return result;
    }

    public ServiceCallResult uploadFileWithPut(File file, String targetUrl, String contentType) {
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("Invalid file: " + file.getAbsolutePath());
        }
        try {
            ServiceCallResult result;
            HttpURLConnection connection = (HttpURLConnection)new URI(targetUrl).toURL().openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", contentType);
            connection.setFixedLengthStreamingMode(file.length());
            try (OutputStream out = connection.getOutputStream();
                 FileInputStream in = new FileInputStream(file);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                out.flush();
                result = new ServiceCallResult("{}", connection.getResponseCode(), connection.getResponseMessage());
            }
            catch (IOException e) {
                log.error("Error uploading file with PUT", (Throwable)e);
                result = new ServiceCallResult("{}", -1, e.getMessage());
            }
            return result;
        }
        catch (IOException | URISyntaxException e) {
            log.error("Error uploading file with PUT", (Object)(e.getClass().getSimpleName() + ": " + String.valueOf(e)));
            ServiceCallResult result = new ServiceCallResult("{}", -1, e.getClass().getSimpleName() + ": " + e.getMessage());
            return result;
        }
    }

    public ServiceCallResult readResponse(HttpURLConnection connection) throws IOException {
        ServiceCallResult result = null;
        int responseCode = connection.getResponseCode();
        if (ServiceCallResult.isHttpSuccess(responseCode)) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder responseStr = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    responseStr.append(line.trim());
                }
                result = new ServiceCallResult(responseStr.toString(), responseCode, connection.getResponseMessage());
            }
        } else {
            result = new ServiceCallResult("{}", responseCode, connection.getResponseMessage());
        }
        return result;
    }
}

