/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.service.discovery;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.labs.hyland.content.intelligence.AuthenticationToken;
import org.nuxeo.labs.hyland.content.intelligence.AuthenticationTokenDiscovery;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCall;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;
import org.nuxeo.labs.hyland.content.intelligence.service.ServicesUtils;
import org.nuxeo.labs.hyland.content.intelligence.service.discovery.HylandKDService;
import org.nuxeo.labs.hyland.content.intelligence.service.discovery.KDDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class HylandKDServiceImpl
extends DefaultComponent
implements HylandKDService {
    private static final Logger log = LogManager.getLogger(HylandKDServiceImpl.class);
    public static final String AUTH_BASE_URL_PARAM = "nuxeo.hyland.cic.auth.baseUrl";
    public static final String AUTH_ENDPOINT = "/connect/token";
    public static final String DISCOVERY_CLIENT_ID_PARAM = "nuxeo.hyland.cic.discovery.clientId";
    public static final String DISCOVERY_CLIENT_SECRET_PARAM = "nuxeo.hyland.cic.discovery.clientSecret";
    public static final String DISCOVERY_BASE_URL_PARAM = "nuxeo.hyland.cic.discovery.baseUrl";
    public static final String DISCOVERY_ENVIRONMENT_PARAM = "nuxeo.hyland.cic.discovery.environment";
    public static final String DISCOVERY_DEFAULT_SOURCEID_PARAM = "nuxeo.hyland.cic.discovery.default.sourceId";
    public static final String DISCOVERY_DEFAULT_AGENTID_PARAM = "nuxeo.hyland.cic.discovery.default.agentId";
    public static final String PULL_RESULTS_MAX_TRIES_PARAM = "nuxeo.hyland.cic.discovery.pullResultsMaxTries";
    public static final int PULL_RESULTS_MAX_TRIES_DEFAULT = 10;
    public static final String PULL_RESULTS_SLEEP_INTERVAL_PARAM = "nuxeo.hyland.cic.discovery.pullResultsSleepInterval";
    public static final int PULL_RESULTS_SLEEP_INTERVAL_DEFAULT = 3000;
    protected static Map<String, AuthenticationToken> discoveryAuthTokens = null;
    protected static String defaultSourceId;
    protected static String defaultAgentId;
    protected static int pullResultsMaxTries;
    protected static int pullResultsSleepIntervalMS;
    protected static ServiceCall serviceCall;
    protected static final String EXT_POINT_KD = "knowledgeDiscovery";
    protected Map<String, KDDescriptor> kdContribs = new HashMap<String, KDDescriptor>();
    public static final String CONFIG_DEFAULT = "default";

    public HylandKDServiceImpl() {
        this.initialize();
    }

    protected void initialize() {
        defaultSourceId = Framework.getProperty((String)DISCOVERY_DEFAULT_SOURCEID_PARAM);
        defaultAgentId = Framework.getProperty((String)DISCOVERY_DEFAULT_AGENTID_PARAM);
        pullResultsMaxTries = ServicesUtils.configParamToInt(PULL_RESULTS_MAX_TRIES_PARAM, 10);
        pullResultsSleepIntervalMS = ServicesUtils.configParamToInt(PULL_RESULTS_SLEEP_INTERVAL_PARAM, 3000);
    }

    protected KDDescriptor getDescriptor(String configName) {
        if (StringUtils.isBlank((CharSequence)configName)) {
            configName = CONFIG_DEFAULT;
        }
        return this.kdContribs.get(configName);
    }

    protected String getToken(String configName) {
        if (StringUtils.isBlank((CharSequence)configName)) {
            configName = CONFIG_DEFAULT;
        }
        AuthenticationToken token = discoveryAuthTokens.get(configName);
        return token.getToken();
    }

    @Override
    public ServiceCallResult invokeDiscovery(String configName, String httpMethod, String endpoint, String jsonPayload) {
        return this.invokeDiscovery(configName, httpMethod, endpoint, jsonPayload, null);
    }

    @Override
    public ServiceCallResult invokeDiscovery(String configName, String httpMethod, String endpoint, String jsonPayload, Map<String, String> extraHeaders) {
        ServiceCallResult result = null;
        String bearer = this.getToken(configName);
        if (StringUtils.isBlank((CharSequence)bearer)) {
            throw new NuxeoException("No authentication info for calling the Enrichment service.");
        }
        KDDescriptor config = this.getDescriptor(configName);
        Object targetUrl = config.getBaseUrl();
        if (!endpoint.startsWith("/")) {
            targetUrl = (String)targetUrl + "/";
        }
        targetUrl = (String)targetUrl + endpoint;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "*/*");
        headers.put("Authorization", "Bearer " + bearer);
        headers.put("Content-Type", "application/json");
        headers.put("Hxp-Environment", config.getEnvironment());
        headers.put("Hxp-App", "hxai-discovery");
        if (extraHeaders != null && extraHeaders.size() > 0) {
            for (String headerName : extraHeaders.keySet()) {
                headers.put(headerName, extraHeaders.get(headerName));
            }
        }
        httpMethod = httpMethod.toUpperCase();
        switch (httpMethod) {
            case "GET": {
                result = serviceCall.get((String)targetUrl, headers);
                break;
            }
            case "POST": {
                result = serviceCall.post((String)targetUrl, headers, jsonPayload);
                break;
            }
            case "PUT": {
                result = serviceCall.put((String)targetUrl, headers, jsonPayload);
                break;
            }
            default: {
                throw new NuxeoException("Only GET, POST and PUT are supported.");
            }
        }
        return result;
    }

    @Override
    public ServiceCallResult getAllAgents(String configName, Map<String, String> extraHeaders) {
        ServiceCallResult result = this.invokeDiscovery(configName, "GET", "/agents", null, extraHeaders);
        return result;
    }

    @Override
    public ServiceCallResult askQuestion(String configName, String agentId, String question, List<String> contextObjectIds, String extraPayloadJsonStr, Map<String, String> extraHeaders) {
        ServiceCallResult result = null;
        if (StringUtils.isBlank((CharSequence)agentId)) {
            agentId = defaultAgentId;
        }
        if (StringUtils.isBlank((CharSequence)agentId)) {
            throw new NuxeoException("No agentId");
        }
        String endPoint = "/agent/agents/" + agentId + "/questions";
        JSONObject payload = new JSONObject();
        payload.put("question", (Object)question);
        JSONArray contextObjectIdsArray = new JSONArray(contextObjectIds);
        payload.put("contextObjectIds", (Object)contextObjectIdsArray);
        if (StringUtils.isNotBlank((CharSequence)extraPayloadJsonStr)) {
            JSONObject extraJson = new JSONObject(extraPayloadJsonStr);
            Iterator keys = extraJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                payload.put(key, extraJson.get(key));
            }
        }
        result = this.invokeDiscovery(configName, "POST", endPoint, payload.toString(), extraHeaders);
        return result;
    }

    @Override
    public ServiceCallResult getAnswer(String configName, String questionId, Map<String, String> extraHeaders) throws InterruptedException {
        ServiceCallResult result = null;
        String endPoint = "/qna/questions/" + questionId + "/answer";
        int count = 0;
        boolean gotIt = false;
        do {
            if (++count > 2) {
                log.info("getAnswer(), trying to get an answer to question ID " + questionId + ", call " + count + "/" + pullResultsMaxTries + ".");
            } else if (count > 9) {
                log.warn("getAnswer(), trying to get an answer to question ID " + questionId + ", call " + count + "/" + pullResultsMaxTries + ".");
            }
            result = this.invokeDiscovery(configName, "GET", endPoint, null, extraHeaders);
            if (!result.callResponseOK()) {
                Thread.sleep(pullResultsSleepIntervalMS);
                continue;
            }
            JSONObject response = result.getResponseAsJSONObject();
            String answer = response.optString("answer", null);
            gotIt = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{answer});
            if (gotIt) continue;
            Thread.sleep(pullResultsSleepIntervalMS);
        } while (!gotIt && count < pullResultsMaxTries);
        return result;
    }

    @Override
    public ServiceCallResult askQuestionAndGetAnswer(String configName, String agentId, String question, List<String> contextObjectIds, String extraPayloadJsonStr, Map<String, String> extraHeaders) throws InterruptedException {
        ServiceCallResult result = null;
        result = this.askQuestion(configName, agentId, question, contextObjectIds, extraPayloadJsonStr, extraHeaders);
        if (result.getResponseCode() != 202) {
            return result;
        }
        JSONObject response = result.getResponseAsJSONObject();
        String questionId = response.getString("questionId");
        result = this.getAnswer(configName, questionId, extraHeaders);
        return result;
    }

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    public void registerExtension(Extension extension) {
        Object[] contribs;
        super.registerExtension(extension);
        if (this.kdContribs == null) {
            this.kdContribs = new HashMap<String, KDDescriptor>();
        }
        if (EXT_POINT_KD.equals(extension.getExtensionPoint()) && (contribs = extension.getContributions()) != null) {
            for (Object contrib : contribs) {
                KDDescriptor desc = (KDDescriptor)contrib;
                this.kdContribs.put(desc.getName(), desc);
            }
        }
    }

    public void unregisterExtension(Extension extension) {
        Object[] contribs;
        super.unregisterExtension(extension);
        if (this.kdContribs == null) {
            return;
        }
        if (EXT_POINT_KD.equals(extension.getExtensionPoint()) && (contribs = extension.getContributions()) != null) {
            for (Object contrib : contribs) {
                KDDescriptor desc = (KDDescriptor)contrib;
                this.kdContribs.remove(desc.getName());
            }
        }
    }

    public void start(ComponentContext context) {
        if (this.kdContribs == null) {
            log.error("No configuration found for Knowledge Discovery. Calls, if any, will fail.");
        } else {
            discoveryAuthTokens = new HashMap<String, AuthenticationToken>();
            for (Map.Entry<String, KDDescriptor> entry : this.kdContribs.entrySet()) {
                KDDescriptor desc = entry.getValue();
                AuthenticationTokenDiscovery token = new AuthenticationTokenDiscovery(desc.getAuthenticationBaseUrl() + AUTH_ENDPOINT, desc.getClientId(), desc.getClientSecret(), desc.getEnvironment());
                discoveryAuthTokens.put(desc.getName(), token);
                desc.checkConfigAndLogErrors();
            }
        }
    }

    public void stop(ComponentContext context) throws InterruptedException {
    }

    static {
        serviceCall = new ServiceCall();
    }
}

