/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.enrichment.automation;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCall;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;
import org.nuxeo.runtime.api.Framework;

@Operation(id="HylandKnowledgeEnrichment.UploadFile", category="Hyland Knowledge Enrichment", label="CIC Knowledge Enrichement Upload File", description="Granular operation, to be used in conjonction with HylandKnowledgeEnrichment.Invoke, once you got a presigned URL for the file. The result JSON will only have a responseCode (should be 200) and responseMessage properties.")
public class HylandKEUploadFileOp {
    public static final String ID = "HylandKnowledgeEnrichment.UploadFile";
    @Param(name="presignedUrl", required=true)
    protected String presignedUrl;
    @Param(name="mimeType", required=false)
    protected String mimeType = null;

    @OperationMethod
    public Blob run(Blob blob) {
        Blob blob2;
        block9: {
            CloseableFile closeableFile = blob.getCloseableFile();
            try {
                if (StringUtils.isBlank((CharSequence)this.mimeType)) {
                    MimetypeRegistry registry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
                    this.mimeType = registry.getMimetypeFromBlob(blob);
                }
                ServiceCall serviceCall = new ServiceCall();
                ServiceCallResult result = serviceCall.uploadFileWithPut(closeableFile.getFile(), this.presignedUrl, this.mimeType);
                blob2 = Blobs.createJSONBlob((String)result.toJsonString());
                if (closeableFile == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (closeableFile != null) {
                        try {
                            closeableFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
            closeableFile.close();
        }
        return blob2;
    }
}

