/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.enrichment.automation;

import java.io.IOException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;
import org.nuxeo.labs.hyland.content.intelligence.service.enrichment.HylandKEService;

@Operation(id="HylandKnowledgeEnrichment.Curate", category="Hyland Knowledge Enrichment", label="CIC Data Curation on Blob", description="Invoke the Hyland Data Curation (DC) API to curate the blob. jsonOptions is optional, a JSON string that will tune the result.(See DC documentation for details, limitation, etc.). configName is the name of the XML configuration to use (if not passed, using 'default')")
public class HylandKECurateOp {
    public static final String ID = "HylandKnowledgeEnrichment.Curate";
    @Context
    protected HylandKEService keService;
    @Param(name="configName", required=false)
    protected String configName;
    @Param(name="jsonOptions", required=false)
    protected String jsonOptions;

    @OperationMethod
    public Blob run(Blob blob) {
        ServiceCallResult result;
        try {
            result = this.keService.curate(this.configName, blob, this.jsonOptions);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        return Blobs.createJSONBlob((String)result.toJsonString());
    }
}

