/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.enrichment.automation;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;
import org.nuxeo.labs.hyland.content.intelligence.service.enrichment.HylandKEService;

@Operation(id="HylandKnowledgeEnrichment.Enrich", category="Hyland Knowledge Enrichment", label="CIC Knowledge Enrichement on Blob", description="Invoke the Hyland Knowledge Enrichment (KE) API to enrich the blob. actions is a list of actions to process (image-description, image-embeddings, \u2026), classes a list of values to be used for classification, and similarValues is used for metadata endpoint. It must be passed as a. (See KE documentation for details, limitation, etc.) configName is the name of the XML configuration to use (if not passed, using 'default')")
public class HylandKEEnrichOp {
    public static final String ID = "HylandKnowledgeEnrichment.Enrich";
    @Context
    protected HylandKEService keService;
    @Param(name="actions", required=true)
    protected String actions;
    @Param(name="classes", required=false)
    protected String classes = null;
    @Param(name="similarMetadataJsonArrayStr", required=false)
    protected String similarMetadataJsonArrayStr = null;
    @Param(name="extraJsonPayloadStr", required=false)
    protected String extraJsonPayloadStr = null;
    @Param(name="configName", required=false)
    protected String configName;

    @OperationMethod
    public Blob run(Blob blob) {
        ServiceCallResult result;
        List<String> theActions = Arrays.stream(this.actions.split(",")).map(String::trim).toList();
        List<String> theClasses = null;
        if (StringUtils.isNotBlank((CharSequence)this.classes)) {
            theClasses = Arrays.stream(this.classes.split(",")).map(String::trim).toList();
        }
        try {
            result = this.keService.enrich(this.configName, blob, theActions, theClasses, this.similarMetadataJsonArrayStr, this.extraJsonPayloadStr);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        return Blobs.createJSONBlob((String)result.toJsonString());
    }
}

